/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.rules;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.css.rules.CssRule;
import org.sonar.css.rules.RuleUtils;

@Rule(key="S4649")
public class FontFamilyNoMissingGenericFamilyKeyword
implements CssRule {
    private static final String DEFAULT_IGNORE_FONT_FAMILIES = "";
    @RuleProperty(key="ignoreFontFamilies", description="Comma-separated list of font families to ignore. Each value can be a string or a regular expression with the syntax /pattern/.", defaultValue="")
    String ignoreFontFamilies = "";

    @Override
    public String stylelintKey() {
        return "font-family-no-missing-generic-family-keyword";
    }

    @Override
    public List<Object> stylelintOptions() {
        return Arrays.asList(true, new StylelintIgnoreOption(RuleUtils.splitAndTrim(this.ignoreFontFamilies)));
    }

    private static class StylelintIgnoreOption {
        private final List<String> ignoreFontFamilies;

        StylelintIgnoreOption(List<String> ignoreFontFamilies) {
            this.ignoreFontFamilies = ignoreFontFamilies;
        }
    }
}

