/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.rules;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.css.rules.CssRule;
import org.sonar.css.rules.RuleUtils;

@Rule(key="S4662")
public class AtRuleNoUnknown
implements CssRule {
    private static final String DEFAULT_IGNORED_AT_RULES = "value,at-root,content,debug,each,else,error,for,function,if,include,mixin,return,warn,while,extend,use,forward,tailwind,apply,layer,container,theme,/^@.*/";
    @RuleProperty(key="ignoreAtRules", description="Comma-separated list of \"at-rules\" to consider as valid.", defaultValue="value,at-root,content,debug,each,else,error,for,function,if,include,mixin,return,warn,while,extend,use,forward,tailwind,apply,layer,container,theme,/^@.*/")
    String ignoredAtRules = "value,at-root,content,debug,each,else,error,for,function,if,include,mixin,return,warn,while,extend,use,forward,tailwind,apply,layer,container,theme,/^@.*/";

    @Override
    public String stylelintKey() {
        return "at-rule-no-unknown";
    }

    @Override
    public List<Object> stylelintOptions() {
        return Arrays.asList(true, new StylelintIgnoreOption(RuleUtils.splitAndTrim(this.ignoredAtRules)));
    }

    private static class StylelintIgnoreOption {
        private final List<String> ignoreAtRules;

        StylelintIgnoreOption(List<String> ignoreAtRules) {
            this.ignoreAtRules = ignoreAtRules;
        }
    }
}

