/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.css.CssRules;
import org.sonar.css.StylelintReport;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class StylelintReportSensor
implements Sensor {
    public static final String STYLELINT = "stylelint";
    public static final String STYLELINT_REPORT_PATHS = "sonar.css.stylelint.reportPaths";
    public static final String STYLELINT_REPORT_PATHS_DEFAULT_VALUE = "";
    private static final Logger LOG = LoggerFactory.getLogger(StylelintReportSensor.class);
    private static final String FILE_EXCEPTION_MESSAGE = "No issues information will be saved as the report file can't be read.";
    private static final ByteOrderMark[] BYTE_ORDER_MARKS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE};
    private final CssRules cssRules;
    private ExternalRuleLoader stylelintRuleLoader = StylelintReportSensor.getStylelintRuleLoader();

    public StylelintReportSensor(CheckFactory checkFactory) {
        this.cssRules = new CssRules(checkFactory);
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyWhenConfiguration(conf -> conf.hasKey(STYLELINT_REPORT_PATHS)).name("Import of stylelint issues");
    }

    public void execute(SensorContext context) {
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, STYLELINT_REPORT_PATHS);
        reportFiles.forEach(report -> this.importReport((File)report, context));
    }

    private void importReport(File report, SensorContext context) {
        LOG.info("Importing {}", (Object)report.getAbsoluteFile());
        try (BOMInputStream bomInputStream = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(Files.newInputStream(report.toPath(), new OpenOption[0]))).setByteOrderMarks(BYTE_ORDER_MARKS).get();){
            StylelintReport.IssuesPerFile[] issues;
            String charsetName = bomInputStream.getBOMCharsetName();
            if (charsetName == null) {
                charsetName = StandardCharsets.UTF_8.name();
            }
            for (StylelintReport.IssuesPerFile issuesPerFile : issues = new Gson().fromJson((Reader)new InputStreamReader((InputStream)bomInputStream, charsetName), StylelintReport.IssuesPerFile[].class)) {
                InputFile inputFile = StylelintReportSensor.getInputFile(context, issuesPerFile.source);
                if (inputFile == null) continue;
                for (StylelintReport.Issue issue : issuesPerFile.warnings) {
                    this.saveStylelintIssue(context, issue, inputFile);
                }
            }
        }
        catch (IOException e) {
            LOG.error(FILE_EXCEPTION_MESSAGE, e);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Failed to parse json stylelint report", e);
        }
    }

    @Nullable
    private static InputFile getInputFile(SensorContext context, String fileName) {
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.or(predicates.hasRelativePath(fileName), predicates.hasAbsolutePath(fileName)));
        if (inputFile == null) {
            LOG.warn("No input file found for {}. No stylelint issues will be imported on this file.", (Object)fileName);
            return null;
        }
        return inputFile;
    }

    private void saveStylelintIssue(SensorContext context, StylelintReport.Issue issue, InputFile inputFile) {
        String stylelintKey = issue.rule;
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.text).on((InputComponent)inputFile).at(inputFile.selectLine(issue.line));
        newExternalIssue.at(primaryLocation).engineId(STYLELINT).ruleId(stylelintKey).type(this.stylelintRuleLoader.ruleType(stylelintKey)).severity(this.stylelintRuleLoader.ruleSeverity(stylelintKey)).remediationEffortMinutes(this.stylelintRuleLoader.ruleConstantDebtMinutes(stylelintKey)).save();
    }

    public static ExternalRuleLoader getStylelintRuleLoader() {
        return new ExternalRuleLoader(STYLELINT, STYLELINT, "org/sonar/l10n/css/rules/stylelint/rules.json", "css");
    }
}

