/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache;

import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.UnicodeUtil;

@Deprecated
public final class UTF8TaxonomyWriterCache
implements TaxonomyWriterCache,
Accountable {
    private final ThreadLocal<BytesRefBuilder> bytes = new ThreadLocal<BytesRefBuilder>(){

        @Override
        protected BytesRefBuilder initialValue() {
            return new BytesRefBuilder();
        }
    };
    private final Counter bytesUsed = Counter.newCounter();
    private final BytesRefHash map = new BytesRefHash(new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed)));
    private static final int PAGE_BITS = 16;
    private static final int PAGE_SIZE = 65536;
    private static final int PAGE_MASK = 65535;
    private volatile int[][] ordinals = new int[1][];
    private int count;
    private int pageCount;
    private static final byte DELIM_CHAR = 31;

    public UTF8TaxonomyWriterCache() {
        this.ordinals[0] = new int[65536];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(FacetLabel label) {
        int id;
        BytesRef bytes = this.toBytes(label);
        UTF8TaxonomyWriterCache uTF8TaxonomyWriterCache = this;
        synchronized (uTF8TaxonomyWriterCache) {
            id = this.map.find(bytes);
        }
        if (id == -1) {
            return -2;
        }
        int page = id >>> 16;
        int offset = id & 0xFFFF;
        return this.ordinals[page][offset];
    }

    private boolean assertSameOrdinal(FacetLabel label, int id, int ord) {
        int page = (id = -id - 1) >>> 16;
        int offset = id & 0xFFFF;
        int oldOrd = this.ordinals[page][offset];
        if (oldOrd != ord) {
            throw new IllegalArgumentException("label " + label + " was already cached, with old ord=" + oldOrd + " versus new ord=" + ord);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(FacetLabel label, int ord) {
        BytesRef bytes = this.toBytes(label);
        UTF8TaxonomyWriterCache uTF8TaxonomyWriterCache = this;
        synchronized (uTF8TaxonomyWriterCache) {
            int id = this.map.add(bytes);
            if (id < 0) {
                assert (this.assertSameOrdinal(label, id, ord));
                return false;
            }
            assert (id == this.count);
            int page = id >>> 16;
            int offset = id & 0xFFFF;
            if (page == this.pageCount) {
                if (page == this.ordinals.length) {
                    int[][] newOrdinals = new int[ArrayUtil.oversize((int)(page + 1), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
                    System.arraycopy(this.ordinals, 0, newOrdinals, 0, this.ordinals.length);
                    this.ordinals = newOrdinals;
                }
                this.ordinals[page] = new int[65536];
                ++this.pageCount;
            }
            this.ordinals[page][offset] = ord;
            ++this.count;
            return false;
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
        this.map.reinit();
        this.ordinals = new int[1][];
        this.ordinals[0] = new int[65536];
        this.count = 0;
        this.pageCount = 0;
        assert (this.bytesUsed.get() == 0L);
    }

    @Override
    public int size() {
        return this.count;
    }

    public synchronized long ramBytesUsed() {
        return this.bytesUsed.get() + (long)this.pageCount * 65536L * 4L;
    }

    @Override
    public void close() {
    }

    private BytesRef toBytes(FacetLabel label) {
        BytesRefBuilder bytes = this.bytes.get();
        bytes.clear();
        for (int i = 0; i < label.length; ++i) {
            String part = label.components[i];
            if (i > 0) {
                bytes.append((byte)31);
            }
            bytes.grow(bytes.length() + UnicodeUtil.maxUTF8Length((int)part.length()));
            bytes.setLength(UnicodeUtil.UTF16toUTF8((CharSequence)part, (int)0, (int)part.length(), (byte[])bytes.bytes(), (int)bytes.length()));
        }
        return bytes.get();
    }
}

