/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="S1142")
public class TooManyReturnCheck
extends FlexCheck {
    private static final int DEFAULT = 3;
    private final Deque<Integer> returnStatementCounter = new ArrayDeque<Integer>();
    @RuleProperty(key="max", description="Maximum allowed return statements per function", defaultValue="3")
    int max = 3;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FUNCTION_COMMON, FlexGrammar.RETURN_STATEMENT);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.returnStatementCounter.clear();
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.RETURN_STATEMENT)) {
            this.setReturnStatementCounter(this.getReturnStatementCounter() + 1);
        } else {
            this.returnStatementCounter.push(0);
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.FUNCTION_COMMON)) {
            if (this.getReturnStatementCounter() > this.max) {
                this.addIssue(MessageFormat.format("Reduce the number of returns of this function {0,number,integer}, down to the maximum allowed {1,number,integer}.", this.getReturnStatementCounter(), this.max), astNode);
            }
            this.returnStatementCounter.pop();
        }
    }

    private int getReturnStatementCounter() {
        return this.returnStatementCounter.peek();
    }

    private void setReturnStatementCounter(int value) {
        this.returnStatementCounter.pop();
        this.returnStatementCounter.push(value);
    }
}

