/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="S120")
public class PackageNameCheck
extends FlexCheck {
    private static final String DEFAULT = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the package names against", defaultValue="^[a-z]+(\\.[a-z][a-z0-9]*)*$")
    String format = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.PACKAGE_DEF);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    @Override
    public void visitNode(AstNode astNode) {
        String packageIdentifier;
        AstNode nameNode = astNode.getFirstChild(FlexGrammar.PACKAGE_NAME);
        if (nameNode != null && !this.pattern.matcher(packageIdentifier = PackageNameCheck.concatenate(nameNode)).matches()) {
            this.addIssue(MessageFormat.format("Rename this package name to match the regular expression {0}", this.format), astNode);
        }
    }

    private static String concatenate(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (Token token : astNode.getTokens()) {
            sb.append(token.getValue());
        }
        return sb.toString();
    }
}

