/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.sslr.grammar.GrammarRuleKey;

@Rule(key="S1952")
public class InstantiationInLoopCheck
extends FlexCheck {
    private static final GrammarRuleKey[] ITERATION_NODES = new GrammarRuleKey[]{FlexGrammar.DO_STATEMENT, FlexGrammar.WHILE_STATEMENT, FlexGrammar.FOR_STATEMENT};
    private int loopLevel = 0;

    @Override
    public List<AstNodeType> subscribedTo() {
        ArrayList<AstNodeType> types = new ArrayList<AstNodeType>();
        Collections.addAll(types, FlexGrammar.FULL_NEW_EXPR, FlexGrammar.SHORT_NEW_EXPR, FlexGrammar.OBJECT_INITIALISER);
        Collections.addAll(types, ITERATION_NODES);
        return types;
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.loopLevel = 0;
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(ITERATION_NODES)) {
            ++this.loopLevel;
        } else if (this.loopLevel > 0 && !InstantiationInLoopCheck.isNestedNewExpression(astNode)) {
            this.addIssue(MessageFormat.format("Move the instantiation of this \"{0}\" outside the loop.", InstantiationInLoopCheck.getClassName(astNode)), astNode);
        }
    }

    private static boolean isNestedNewExpression(AstNode newExpression) {
        return newExpression.getParent().is(FlexGrammar.FULL_NEW_SUB_EXPR, FlexGrammar.SHORT_NEW_SUB_EXPR);
    }

    private static Object getClassName(AstNode astNode) {
        String currentTokenValue;
        if (astNode.is(FlexGrammar.OBJECT_INITIALISER)) {
            return "Object";
        }
        List<Token> tokens = astNode.getTokens();
        int nbToken = tokens.size();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nbToken && !"[".equals(currentTokenValue = tokens.get(i).getValue()) && !"(".equals(currentTokenValue); ++i) {
            if ("new".equals(currentTokenValue)) continue;
            builder.append(currentTokenValue);
        }
        return builder.toString();
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.is(ITERATION_NODES)) {
            --this.loopLevel;
        }
    }
}

