/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Variable;

@Rule(key="S115")
public class ConstantNameCheck
extends FlexCheck {
    private static final String DEFAULT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the constant names against", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.VARIABLE_DECLARATION_STATEMENT);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.getFirstChild(FlexGrammar.VARIABLE_DEF).getFirstChild(FlexGrammar.VARIABLE_DEF_KIND).getFirstChild(FlexKeyword.CONST) != null) {
            for (AstNode identifier : Variable.getDeclaredIdentifiers(astNode)) {
                String varName = identifier.getTokenValue();
                if (this.pattern.matcher(varName).matches()) continue;
                this.addIssue("Rename this constant '" + varName + "' to match the regular expression " + this.format + "", identifier);
            }
        }
    }
}

