/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public class EdgeNGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(EdgeNGramTokenFilterFactory.class);
    private final int minGram;
    private final int maxGram;
    public static final int SIDE_FRONT = 1;
    public static final int SIDE_BACK = 2;
    private final int side;
    private final boolean preserveOriginal;
    private static final String PRESERVE_ORIG_KEY = "preserve_original";

    EdgeNGramTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name, settings);
        this.minGram = settings.getAsInt("min_gram", Integer.valueOf(1));
        this.maxGram = settings.getAsInt("max_gram", Integer.valueOf(2));
        if (settings.get("side") != null) {
            deprecationLogger.critical(DeprecationCategory.ANALYSIS, "edge_ngram_side_deprecated", "The [side] parameter is deprecated and will be removed. Use a [reverse] before and after the [edge_ngram] instead.", new Object[0]);
        }
        this.side = EdgeNGramTokenFilterFactory.parseSide(settings.get("side", "front"));
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIG_KEY, Boolean.valueOf(false));
    }

    static int parseSide(String side) {
        return switch (side) {
            case "front" -> 1;
            case "back" -> 2;
            default -> throw new IllegalArgumentException("invalid side: " + side);
        };
    }

    public TokenStream create(TokenStream tokenStream) {
        TokenStream result = tokenStream;
        if (this.side == 2) {
            result = new ReverseStringFilter(result);
        }
        result = new EdgeNGramTokenFilter(result, this.minGram, this.maxGram, this.preserveOriginal);
        if (this.side == 2) {
            result = new ReverseStringFilter(result);
        }
        return result;
    }

    public boolean breaksFastVectorHighlighter() {
        return true;
    }

    public TokenFilterFactory getSynonymFilter() {
        throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
    }
}

