/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.internal.HttpValidator;
import org.elasticsearch.transport.Transports;

public class Netty4HttpHeaderValidator
extends ChannelInboundHandlerAdapter {
    private final HttpValidator validator;
    private final ThreadContext threadContext;
    private ArrayDeque<HttpObject> pending = new ArrayDeque(4);
    private State state = State.WAITING_TO_START;

    public Netty4HttpHeaderValidator(HttpValidator validator, ThreadContext threadContext) {
        this.validator = validator;
        this.threadContext = threadContext;
    }

    State getState() {
        return this.state;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (msg instanceof HttpObject);
        HttpObject httpObject = (HttpObject)msg;
        switch (this.state) {
            case WAITING_TO_START: {
                assert (this.pending.isEmpty());
                this.pending.add((HttpObject)ReferenceCountUtil.retain((Object)httpObject));
                this.requestStart(ctx);
                assert (this.state == State.QUEUEING_DATA);
                assert (!ctx.channel().config().isAutoRead());
                break;
            }
            case QUEUEING_DATA: {
                this.pending.add((HttpObject)ReferenceCountUtil.retain((Object)httpObject));
                break;
            }
            case FORWARDING_DATA_UNTIL_NEXT_REQUEST: {
                assert (this.pending.isEmpty());
                if (httpObject instanceof LastHttpContent) {
                    this.state = State.WAITING_TO_START;
                }
                ctx.fireChannelRead((Object)httpObject);
                break;
            }
            case DROPPING_DATA_UNTIL_NEXT_REQUEST: {
                assert (this.pending.isEmpty());
                if (httpObject instanceof LastHttpContent) {
                    this.state = State.WAITING_TO_START;
                }
                ReferenceCountUtil.release((Object)httpObject);
                break;
            }
            case DROPPING_DATA_PERMANENTLY: {
                assert (this.pending.isEmpty());
                ReferenceCountUtil.release((Object)httpObject);
                ctx.channel().config().setAutoRead(false);
            }
        }
    }

    private void requestStart(final ChannelHandlerContext ctx) {
        assert (this.state == State.WAITING_TO_START);
        if (this.pending.isEmpty()) {
            return;
        }
        HttpObject httpObject = this.pending.getFirst();
        HttpRequest httpRequest = httpObject instanceof HttpRequest && httpObject.decoderResult().isSuccess() ? (HttpRequest)httpObject : null;
        this.state = State.QUEUEING_DATA;
        ctx.channel().config().setAutoRead(false);
        if (httpRequest == null) {
            ctx.channel().eventLoop().execute(() -> this.forwardFullRequest(ctx));
        } else {
            assert (Transports.assertDefaultThreadContext((ThreadContext)this.threadContext));
            ActionListener.run((ActionListener)ActionListener.assertOnce((ActionListener)new ContextPreservingActionListener(this.threadContext.wrapRestorable(this.threadContext.newStoredContext()), (ActionListener)new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    assert (Transports.assertDefaultThreadContext((ThreadContext)Netty4HttpHeaderValidator.this.threadContext));
                    ctx.channel().eventLoop().execute(() -> Netty4HttpHeaderValidator.this.forwardFullRequest(ctx));
                }

                public void onFailure(Exception e) {
                    assert (Transports.assertDefaultThreadContext((ThreadContext)Netty4HttpHeaderValidator.this.threadContext));
                    ctx.channel().eventLoop().execute(() -> Netty4HttpHeaderValidator.this.forwardRequestWithDecoderExceptionAndNoContent(ctx, e));
                }
            })), listener -> {
                try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
                    this.validator.validate(httpRequest, ctx.channel(), (ActionListener<Void>)listener);
                }
            });
        }
    }

    private void forwardFullRequest(ChannelHandlerContext ctx) {
        Transports.assertDefaultThreadContext((ThreadContext)this.threadContext);
        assert (ctx.channel().eventLoop().inEventLoop());
        assert (!ctx.channel().config().isAutoRead());
        assert (this.state == State.QUEUEING_DATA);
        ctx.channel().config().setAutoRead(true);
        boolean fullRequestForwarded = Netty4HttpHeaderValidator.forwardData(ctx, this.pending);
        assert (fullRequestForwarded || this.pending.isEmpty());
        if (fullRequestForwarded) {
            this.state = State.WAITING_TO_START;
            this.requestStart(ctx);
        } else {
            this.state = State.FORWARDING_DATA_UNTIL_NEXT_REQUEST;
        }
        assert (this.state == State.WAITING_TO_START || this.state == State.QUEUEING_DATA || this.state == State.FORWARDING_DATA_UNTIL_NEXT_REQUEST);
    }

    private void forwardRequestWithDecoderExceptionAndNoContent(ChannelHandlerContext ctx, Exception e) {
        Transports.assertDefaultThreadContext((ThreadContext)this.threadContext);
        assert (ctx.channel().eventLoop().inEventLoop());
        assert (!ctx.channel().config().isAutoRead());
        assert (this.state == State.QUEUEING_DATA);
        HttpObject messageToForward = this.pending.getFirst();
        boolean fullRequestDropped = Netty4HttpHeaderValidator.dropData(this.pending);
        if (messageToForward instanceof HttpContent) {
            HttpContent toReplace = (HttpContent)messageToForward;
            messageToForward = toReplace.replace(Unpooled.EMPTY_BUFFER);
        }
        messageToForward.setDecoderResult(DecoderResult.failure((Throwable)e));
        ctx.channel().config().setAutoRead(true);
        ctx.fireChannelRead((Object)messageToForward);
        assert (fullRequestDropped || this.pending.isEmpty());
        if (fullRequestDropped) {
            this.state = State.WAITING_TO_START;
            this.requestStart(ctx);
        } else {
            this.state = State.DROPPING_DATA_UNTIL_NEXT_REQUEST;
        }
        assert (this.state == State.WAITING_TO_START || this.state == State.QUEUEING_DATA || this.state == State.DROPPING_DATA_UNTIL_NEXT_REQUEST);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.state = State.DROPPING_DATA_PERMANENTLY;
        while (Netty4HttpHeaderValidator.dropData(this.pending)) {
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean forwardData(ChannelHandlerContext ctx, ArrayDeque<HttpObject> pending) {
        int pendingMessages = pending.size();
        try {
            HttpObject toForward;
            while ((toForward = pending.poll()) != null) {
                ctx.fireChannelRead((Object)toForward);
                ReferenceCountUtil.release((Object)toForward);
                if (!(toForward instanceof LastHttpContent)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Netty4HttpHeaderValidator.maybeResizePendingDown(pendingMessages, pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean dropData(ArrayDeque<HttpObject> pending) {
        int pendingMessages = pending.size();
        try {
            HttpObject toDrop;
            while ((toDrop = pending.poll()) != null) {
                ReferenceCountUtil.release((Object)toDrop, (int)2);
                if (!(toDrop instanceof LastHttpContent)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Netty4HttpHeaderValidator.maybeResizePendingDown(pendingMessages, pending);
        }
    }

    private static void maybeResizePendingDown(int largeSize, ArrayDeque<HttpObject> pending) {
        if (pending.size() <= 4 && largeSize > 32) {
            ArrayDeque<HttpObject> old = pending;
            pending = new ArrayDeque(4);
            pending.addAll(old);
        }
    }

    static enum State {
        WAITING_TO_START,
        QUEUEING_DATA,
        FORWARDING_DATA_UNTIL_NEXT_REQUEST,
        DROPPING_DATA_UNTIL_NEXT_REQUEST,
        DROPPING_DATA_PERMANENTLY;

    }
}

