/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.sensor.SensorContext;

public class Telemetry {
    private static final String RUST_EDITION_NAME = "rust.language.edition";
    private static final String RUST_CLIPPY_EDITION_VERSION_NAME = "rust.clippy.version";
    private static final String RUST_COVERAGE_FORMAT_NAME = "rust.coverage.format";
    private static final String RUST_CLIPPY_USAGE_NAME = "rust.clippy.usage";
    private static final Pattern CLIPPY_VERSION_PATTERN = Pattern.compile("^clippy\\s+(\\d+\\.\\d+\\.\\d+)");

    private Telemetry() {
    }

    public static void reportExternalClippyUsage(SensorContext context) {
        Telemetry.saveTelemetry(context, RUST_CLIPPY_USAGE_NAME, "external");
    }

    public static void reportAnalyzerClippyUsage(SensorContext context) {
        Telemetry.saveTelemetry(context, RUST_CLIPPY_USAGE_NAME, "sonar");
    }

    public static void reportCoverageFormat(SensorContext context, String format) {
        Telemetry.saveTelemetry(context, RUST_COVERAGE_FORMAT_NAME, format);
    }

    public static void reportClippyVersion(SensorContext context, String versionString) {
        Matcher matcher = CLIPPY_VERSION_PATTERN.matcher(versionString);
        if (matcher.find()) {
            Telemetry.saveTelemetry(context, RUST_CLIPPY_EDITION_VERSION_NAME, matcher.group(1));
        }
    }

    public static void reportManifestInfo(SensorContext context, Path cargoManifest) {
        try {
            String edition = Telemetry.findRustEdition(cargoManifest);
            if (edition != null) {
                Telemetry.saveTelemetry(context, RUST_EDITION_NAME, edition);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @CheckForNull
    private static String findRustEdition(Path cargoManifest) throws IOException {
        List<String> lines = Files.readAllLines(cargoManifest);
        String currentSection = null;
        for (String line : lines) {
            String[] parts;
            String trimmed = line.replaceAll("#.*", "").trim();
            if (trimmed.isEmpty()) continue;
            if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                currentSection = trimmed.substring(1, trimmed.length() - 1).trim();
                continue;
            }
            if (!"package".equals(currentSection) || !trimmed.startsWith("edition") || (parts = trimmed.split("=")).length != 2) continue;
            return parts[1].trim().replaceAll("^[\"']", "").replaceAll("[\"']$", "");
        }
        return null;
    }

    private static void saveTelemetry(SensorContext context, String key, String value) {
        context.addTelemetryProperty(key, value);
    }
}

