/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.plugin;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.rust.plugin.AnalysisWarningsWrapper;
import org.sonarsource.rust.plugin.Analyzer;
import org.sonarsource.rust.plugin.AnalyzerFactory;
import org.sonarsource.rust.plugin.PlatformDetection;
import org.sonarsource.rust.plugin.RustRulesDefinition;

public class RustSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(RustSensor.class);
    private final AnalyzerFactory analyzerFactory;
    private final PlatformDetection platformDetection;
    private final AnalysisWarningsWrapper analysisWarnings;

    public RustSensor(AnalyzerFactory analyzerFactory, AnalysisWarningsWrapper analysisWarnings) {
        this(analyzerFactory, analysisWarnings, new PlatformDetection());
    }

    RustSensor(AnalyzerFactory analyzerFactory, AnalysisWarningsWrapper analysisWarnings, PlatformDetection platformDetection) {
        this.analyzerFactory = analyzerFactory;
        this.platformDetection = platformDetection;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("rust").name("Rust");
    }

    public void execute(SensorContext sensorContext) {
        List<InputFile> inputFiles = RustSensor.inputFiles(sensorContext);
        PlatformDetection.Platform platform = this.platformDetection.detect();
        if (platform == PlatformDetection.Platform.UNSUPPORTED) {
            String msg = "Unsupported platform for Rust analysis: " + this.platformDetection.debug();
            LOG.error(msg);
            this.analysisWarnings.addUnique(msg);
            RustSensor.failFastCheck(sensorContext, new IllegalStateException(msg));
            return;
        }
        LOG.info("Detected platform: {}", (Object)platform);
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (RustRulesDefinition.RuleParameter parameter : RustRulesDefinition.parameters()) {
            parameters.put(String.format("%s:%s", parameter.ruleKey(), parameter.paramKey()), parameter.defaultValue());
        }
        for (ActiveRule activeRule : sensorContext.activeRules().findByRepository("rust")) {
            for (Map.Entry parameter : activeRule.params().entrySet()) {
                parameters.put(String.format("%s:%s", activeRule.ruleKey().rule(), parameter.getKey()), (String)parameter.getValue());
            }
        }
        this.analyzerFactory.addParameters(parameters);
        try (Analyzer analyzer = this.analyzerFactory.create(platform);){
            for (InputFile inputFile : inputFiles) {
                RustSensor.analyzeFile(analyzer, sensorContext, inputFile);
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to create Rust analyzer: {}", (Object)ex.getMessage());
            this.analysisWarnings.addUnique("Failed to create Rust analyzer: " + ex.getMessage());
            RustSensor.failFastCheck(sensorContext, ex);
        }
    }

    private static void failFastCheck(SensorContext sensorContext, Exception ex) {
        if (sensorContext.config().getBoolean("sonar.internal.analysis.rust.failFast").orElse(false).booleanValue()) {
            throw new IllegalStateException("Analysis failed", ex);
        }
    }

    private static void analyzeFile(Analyzer analyzer, SensorContext sensorContext, InputFile inputFile) {
        try {
            Analyzer.AnalysisResult result = analyzer.analyze(inputFile.contents());
            RustSensor.saveMeasures(sensorContext, inputFile, result.measures());
            RustSensor.saveHighlighting(sensorContext, inputFile, result.highlightTokens());
            RustSensor.saveCPD(sensorContext, inputFile, result.cpdTokens());
            RustSensor.saveIssues(sensorContext, inputFile, result.issues());
        }
        catch (IOException ex) {
            LOG.error("Failed to analyze file: {}. Reason: {}", (Object)inputFile.filename(), (Object)ex.getMessage());
        }
    }

    private static List<InputFile> inputFiles(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicate predicate = fileSystem.predicates().hasLanguage("rust");
        return StreamSupport.stream(fileSystem.inputFiles(predicate).spliterator(), false).toList();
    }

    private static void saveHighlighting(SensorContext sensorContext, InputFile inputFile, List<Analyzer.HighlightTokens> tokens) {
        NewHighlighting highlighting = sensorContext.newHighlighting();
        highlighting.onFile(inputFile);
        for (Analyzer.HighlightTokens token : tokens) {
            try {
                Analyzer.Location location = token.location();
                TextRange range = inputFile.newRange(location.startLine(), location.startColumn(), location.endLine(), location.endColumn());
                highlighting.highlight(range, TypeOfText.valueOf((String)token.tokenType()));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid highlighting: {}. Reason: {}", (Object)token, (Object)e.getMessage());
            }
        }
        highlighting.save();
    }

    private static void saveMeasures(SensorContext sensorContext, InputFile inputFile, Analyzer.Measures measures) {
        RustSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.NCLOC, measures.ncloc());
        RustSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.COMMENT_LINES, measures.commentLines());
        RustSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.FUNCTIONS, measures.functions());
        RustSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.STATEMENTS, measures.statements());
        RustSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.CLASSES, measures.classes());
        RustSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, measures.cognitiveComplexity());
        RustSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.COMPLEXITY, measures.cyclomaticComplexity());
    }

    private static void saveMetric(SensorContext sensorContext, InputFile inputFile, Metric<Integer> metric, Integer value) {
        sensorContext.newMeasure().on((InputComponent)inputFile).forMetric(metric).withValue((Serializable)value).save();
    }

    private static void saveCPD(SensorContext sensorContext, InputFile inputFile, List<Analyzer.CpdToken> tokens) {
        NewCpdTokens newCpdTokens = sensorContext.newCpdTokens().onFile(inputFile);
        for (Analyzer.CpdToken token : tokens) {
            try {
                newCpdTokens.addToken(token.location().startLine(), token.location().startColumn(), token.location().endLine(), token.location().endColumn(), token.image());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid CPD token: {}. Reason: {}", (Object)token, (Object)e.getMessage());
            }
        }
        newCpdTokens.save();
    }

    private static void saveIssues(SensorContext sensorContext, InputFile inputFile, List<Analyzer.Issue> issues) {
        for (Analyzer.Issue issue : issues) {
            try {
                NewIssue newIssue = sensorContext.newIssue();
                NewIssueLocation location = newIssue.newLocation().on((InputComponent)inputFile).at(inputFile.newRange(issue.location().startLine(), issue.location().startColumn(), issue.location().endLine(), issue.location().endColumn())).message(issue.message());
                newIssue.forRule(RuleKey.of((String)"rust", (String)issue.ruleKey())).at(location);
                for (Analyzer.SecondaryLocation secondaryLocation : issue.secondaryLocations()) {
                    newIssue.addLocation(newIssue.newLocation().on((InputComponent)inputFile).at(inputFile.newRange(secondaryLocation.location().startLine(), secondaryLocation.location().startColumn(), secondaryLocation.location().endLine(), secondaryLocation.location().endColumn())).message(secondaryLocation.message()));
                }
                newIssue.save();
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid issue: {}. Reason: {}", (Object)issue, (Object)e.getMessage());
            }
        }
    }
}

