/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.plugin;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;
import org.sonarsource.rust.clippy.ClippyRule;

public class RustRulesDefinition
implements RulesDefinition {
    private static final String RESOURCE_BASE_PATH = "/org/sonar/l10n/rust/rules/rust";
    private static final String CLIPPY_RULES_PATH = "/org/sonar/l10n/rust/rules/clippy/rules.json";
    private static final String SONAR_WAY_PATH = "/org/sonar/l10n/rust/rules/rust/Sonar_way_profile.json";
    private static final Map<String, String> RULE_KEY_TO_LINT_ID = new HashMap<String, String>();
    static final Map<String, ClippyRule> CLIPPY_RULES = new HashMap<String, ClippyRule>();
    public static final Set<String> SONAR_RULES;
    private final SonarRuntime sonarRuntime;

    public RustRulesDefinition(SonarRuntime sonarRuntime) {
        this.sonarRuntime = sonarRuntime;
    }

    public void define(RulesDefinition.Context context) {
        RuleMetadataLoader loader = new RuleMetadataLoader(RESOURCE_BASE_PATH, SONAR_WAY_PATH, this.sonarRuntime);
        RulesDefinition.NewRepository repository = context.createRepository("rust", "rust").setName("SonarAnalyzer");
        ArrayList<String> ruleKeys = new ArrayList<String>();
        ruleKeys.addAll(CLIPPY_RULES.values().stream().map(ClippyRule::ruleKey).toList());
        ruleKeys.addAll(SONAR_RULES);
        loader.addRulesByRuleKey(repository, ruleKeys);
        for (RuleParameter param : RustRulesDefinition.parameters()) {
            repository.rule(param.ruleKey()).createParam(param.paramKey()).setDefaultValue(param.defaultValue()).setDescription(param.description()).setType(param.type());
        }
        repository.done();
    }

    public static List<RuleParameter> parameters() {
        return List.of(new RuleParameter("S3776", "threshold", "15", "The maximum authorized complexity", RuleParamType.INTEGER));
    }

    public static String lintIdToRuleKey(String lintId) {
        return Optional.ofNullable(CLIPPY_RULES.get(lintId)).map(ClippyRule::ruleKey).orElse(null);
    }

    public static String ruleKeyToLintId(String ruleKey) {
        return RULE_KEY_TO_LINT_ID.get(ruleKey);
    }

    public static String lintIdToMessage(String lintId) {
        return Optional.ofNullable(CLIPPY_RULES.get(lintId)).map(ClippyRule::message).orElse(null);
    }

    static {
        try {
            ClippyRule[] rules;
            InputStream stream = RustRulesDefinition.class.getResourceAsStream(CLIPPY_RULES_PATH);
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            for (ClippyRule rule : rules = new Gson().fromJson((Reader)reader, ClippyRule[].class)) {
                if (rule.ruleKey() == null) continue;
                CLIPPY_RULES.put(rule.lintId(), rule);
                RULE_KEY_TO_LINT_ID.put(rule.ruleKey(), rule.lintId());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Clippy rules resource", e);
        }
        SONAR_RULES = Set.of("S2260", "S3776");
    }

    public record RuleParameter(String ruleKey, String paramKey, String defaultValue, String description, RuleParamType type) {
    }
}

