/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.plugin;

import java.util.Locale;
import org.sonarsource.rust.plugin.SystemWrapper;

class PlatformDetection {
    private final SystemWrapper system;

    PlatformDetection() {
        this(new SystemWrapper());
    }

    PlatformDetection(SystemWrapper system) {
        this.system = system;
    }

    Platform detect() {
        String osName = this.system.getOsName();
        String lowerCaseOsName = osName.toLowerCase(Locale.ROOT);
        if (lowerCaseOsName.contains("windows") && this.isX64()) {
            return Platform.WIN_X64;
        }
        if (lowerCaseOsName.contains("linux")) {
            if (this.isX64()) {
                return Platform.LINUX_X64_MUSL;
            }
            if (this.isARM64()) {
                return Platform.LINUX_AARCH64;
            }
        } else if (lowerCaseOsName.contains("mac os")) {
            return this.isARM64() ? Platform.DARWIN_AARCH64 : Platform.DARWIN_X86_64;
        }
        return Platform.UNSUPPORTED;
    }

    String debug() {
        return String.format("os: %s, arch: %s", this.system.getOsName(), this.system.getOsArch());
    }

    private boolean isX64() {
        return this.system.getOsArch().contains("amd64");
    }

    private boolean isARM64() {
        return this.system.getOsArch().contains("aarch64");
    }

    static enum Platform {
        WIN_X64,
        LINUX_X64_MUSL,
        LINUX_AARCH64,
        DARWIN_AARCH64,
        DARWIN_X86_64,
        UNSUPPORTED;

    }
}

