/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.TempFolder;
import org.sonarsource.rust.plugin.Analyzer;
import org.sonarsource.rust.plugin.PlatformDetection;
import org.tukaani.xz.XZInputStream;

@ScannerSide
public class AnalyzerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyzerFactory.class);
    private final TempFolder tempFolder;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public AnalyzerFactory(TempFolder tempFolder) {
        this.tempFolder = tempFolder;
    }

    Analyzer create(PlatformDetection.Platform platform) throws IOException {
        String pathInJar = AnalyzerFactory.pathInJar(platform);
        LOG.debug("Extracting analyzer from {}", (Object)pathInJar);
        try (InputStream stream = this.getClass().getResourceAsStream(pathInJar);){
            if (stream == null) {
                throw new IllegalStateException("Analyzer binary not found");
            }
            String suffix = platform == PlatformDetection.Platform.WIN_X64 ? ".exe" : "";
            Path path = this.tempFolder.newFile("analyzer-", suffix).toPath();
            LOG.debug("Copying analyzer to {}", (Object)path);
            Files.copy(new XZInputStream(stream), path, StandardCopyOption.REPLACE_EXISTING);
            if (!Files.isExecutable(path)) {
                Files.setPosixFilePermissions(path, Set.of(PosixFilePermission.OWNER_EXECUTE));
            }
            Analyzer analyzer = new Analyzer(List.of(path.toString()), this.parameters);
            return analyzer;
        }
    }

    public void addParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    static String pathInJar(PlatformDetection.Platform platform) {
        return switch (platform) {
            case PlatformDetection.Platform.WIN_X64 -> "/analyzer/win-x64/analyzer.exe.xz";
            case PlatformDetection.Platform.LINUX_X64_MUSL -> "/analyzer/linux-x64-musl/analyzer.xz";
            case PlatformDetection.Platform.LINUX_AARCH64 -> "/analyzer/linux-aarch64-musl/analyzer.xz";
            case PlatformDetection.Platform.DARWIN_AARCH64 -> "/analyzer/darwin-aarch64/analyzer.xz";
            case PlatformDetection.Platform.DARWIN_X86_64 -> "/analyzer/darwin-x86_64/analyzer.xz";
            default -> throw new IllegalStateException("Unsupported platform");
        };
    }
}

