/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.plugin;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.rust.common.ProcessWrapper;

public class Analyzer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Analyzer.class);
    private final ProcessWrapper process;
    private final DataOutputStream outputStream;
    private final DataInputStream inputStream;

    public Analyzer(List<String> command, Map<String, String> parameters) {
        try {
            this.process = new ProcessWrapper();
            this.process.start(command, null, null, arg_0 -> ((Logger)LOG).warn(arg_0));
            this.outputStream = new DataOutputStream(this.process.getOutputStream());
            this.inputStream = new DataInputStream(this.process.getInputStream());
            this.writeString("sonar");
            this.writeMap(parameters);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to start the analyzer process", ex);
        }
    }

    public AnalysisResult analyze(String code) throws IOException {
        this.writeString("analyze");
        byte[] bytes = code.getBytes(StandardCharsets.UTF_8);
        this.writeInt(bytes.length);
        this.write(bytes);
        ArrayList<HighlightTokens> highlightTokens = new ArrayList<HighlightTokens>();
        Measures measures = new Measures();
        ArrayList<CpdToken> cpdTokens = new ArrayList<CpdToken>();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        while (true) {
            Location location;
            String messageType;
            if ("highlight".equals(messageType = this.readString())) {
                String tokenType = this.readString();
                location = this.readLocation();
                highlightTokens.add(new HighlightTokens(tokenType, location));
                continue;
            }
            if ("metrics".equals(messageType)) {
                int ncloc = this.inputStream.readInt();
                int commentLines = this.inputStream.readInt();
                int functions = this.inputStream.readInt();
                int statements = this.inputStream.readInt();
                int classes = this.inputStream.readInt();
                int cognitiveComplexity = this.inputStream.readInt();
                int cyclomaticComplexity = this.inputStream.readInt();
                measures = new Measures(ncloc, commentLines, functions, statements, classes, cognitiveComplexity, cyclomaticComplexity);
                continue;
            }
            if ("cpd".equals(messageType)) {
                String image = this.readString();
                location = this.readLocation();
                cpdTokens.add(new CpdToken(image, location));
                continue;
            }
            if (!"issue".endsWith(messageType)) break;
            String ruleKey = this.readString();
            String message = this.readString();
            Location location2 = this.readLocation();
            int numSecondaryLocations = this.inputStream.readInt();
            ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
            for (int i = 0; i < numSecondaryLocations; ++i) {
                String secondaryMessage = this.readString();
                Location secondaryLocation = this.readLocation();
                secondaryLocations.add(new SecondaryLocation(secondaryMessage, secondaryLocation));
            }
            issues.add(new Issue(ruleKey, message, location2, secondaryLocations));
        }
        return new AnalysisResult(highlightTokens, measures, cpdTokens, issues);
    }

    @Override
    public void close() {
        this.process.destroyForcibly();
    }

    private String readString() throws IOException {
        int length = this.inputStream.readInt();
        byte[] bytes = new byte[length];
        this.inputStream.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private Location readLocation() throws IOException {
        int startLine = this.inputStream.readInt();
        int startColumn = this.inputStream.readInt();
        int endLine = this.inputStream.readInt();
        int endColumn = this.inputStream.readInt();
        return new Location(startLine, startColumn, endLine, endColumn);
    }

    private void writeInt(int value) throws IOException {
        this.outputStream.writeInt(value);
        this.outputStream.flush();
    }

    private void writeString(String value) throws IOException {
        this.outputStream.writeInt(value.length());
        this.outputStream.write(value.getBytes(StandardCharsets.UTF_8));
        this.outputStream.flush();
    }

    private void write(byte[] bytes) throws IOException {
        this.outputStream.write(bytes);
        this.outputStream.flush();
    }

    private void writeMap(Map<String, String> map) throws IOException {
        this.outputStream.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.writeString(entry.getKey());
            this.writeString(entry.getValue());
        }
    }

    public record Measures(int ncloc, int commentLines, int functions, int statements, int classes, int cognitiveComplexity, int cyclomaticComplexity) {
        public Measures() {
            this(0, 0, 0, 0, 0, 0, 0);
        }
    }

    public record Location(int startLine, int startColumn, int endLine, int endColumn) {
    }

    public record HighlightTokens(String tokenType, Location location) {
    }

    public record CpdToken(String image, Location location) {
    }

    public record SecondaryLocation(String message, Location location) {
    }

    public record Issue(String ruleKey, String message, Location location, List<SecondaryLocation> secondaryLocations) {
    }

    public record AnalysisResult(List<HighlightTokens> highlightTokens, Measures measures, List<CpdToken> cpdTokens, List<Issue> issues) {
    }
}

