/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.coverage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonarsource.rust.common.FileLocator;
import org.sonarsource.rust.common.ReportProvider;
import org.sonarsource.rust.coverage.CodeCoverage;
import org.sonarsource.rust.coverage.CoverageUtils;
import org.sonarsource.rust.coverage.LcovParser;
import org.sonarsource.rust.plugin.Telemetry;

public class LcovSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(LcovSensor.class);
    public static final String COVERAGE_REPORT_PATHS = "sonar.rust.lcov.reportPaths";

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Rust LCOV Coverage").onlyOnLanguage("rust").onlyWhenConfiguration(config -> config.hasKey(COVERAGE_REPORT_PATHS));
    }

    public void execute(SensorContext context) {
        LOG.debug("Processing LCOV coverage reports");
        Telemetry.reportCoverageFormat(context, "LCOV");
        ReportProvider reportProvider = new ReportProvider("LCOV", COVERAGE_REPORT_PATHS);
        List<File> reportFiles = reportProvider.getReportFiles(context);
        if (reportFiles.isEmpty()) {
            LOG.warn("No LCOV report files found");
            return;
        }
        LOG.debug("Found {} LCOV report files", (Object)reportFiles.size());
        FileSystem fs = context.fileSystem();
        FilePredicate predicate = fs.predicates().and(fs.predicates().hasType(InputFile.Type.MAIN), fs.predicates().hasLanguage("rust"));
        FileLocator fileLocator = new FileLocator(fs.inputFiles(predicate));
        ArrayList<CodeCoverage> coverages = new ArrayList<CodeCoverage>();
        for (File reportFile : reportFiles) {
            try {
                LOG.debug("Parsing LCOV report: {}", (Object)reportFile);
                LcovParser parser = LcovParser.create(context, reportFile, fileLocator);
                LcovParser.ParsingResult parsingResult = parser.parse();
                List<String> problems = parsingResult.problems();
                if (!problems.isEmpty()) {
                    LOG.warn("Found {} problems in LCOV report: {}. More details in verbose mode", (Object)problems.size(), (Object)reportFile);
                    problems.forEach(arg_0 -> ((Logger)LOG).debug(arg_0));
                } else {
                    LOG.debug("Successfully parsed LCOV report");
                }
                coverages.addAll(parsingResult.coverages());
            }
            catch (Exception e) {
                LOG.error("Failed to parse LCOV report", (Throwable)e);
            }
        }
        for (CodeCoverage coverage : coverages) {
            try {
                LOG.debug("Saving coverage for file: {}", (Object)coverage.getInputFile());
                CoverageUtils.saveCoverage(context, coverage);
                LOG.debug("Successfully saved coverage");
            }
            catch (Exception e) {
                LOG.error("Failed to save coverage", (Throwable)e);
            }
        }
        LOG.debug("Processed LCOV coverage reports");
    }
}

