/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.coverage;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.rust.common.FileLocator;
import org.sonarsource.rust.coverage.CodeCoverage;

public class LcovParser {
    private final SensorContext context;
    private final File reportFile;
    private final List<String> lines;
    private final FileLocator fileLocator;
    private final Map<InputFile, CodeCoverage> coverageByFile = new HashMap<InputFile, CodeCoverage>();
    private final List<String> problems = new ArrayList<String>();

    private LcovParser(SensorContext context, File report, List<String> lines, FileLocator fileLocator) {
        this.context = context;
        this.reportFile = report;
        this.lines = lines;
        this.fileLocator = fileLocator;
    }

    public static LcovParser create(SensorContext context, File reportFile, FileLocator fileLocator) {
        try {
            List<String> lines = Files.readAllLines(reportFile.toPath());
            return new LcovParser(context, reportFile, lines, fileLocator);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read LCOV report: " + String.valueOf(reportFile), e);
        }
    }

    public ParsingResult parse() {
        CodeCoverage coverage = null;
        int lineCounter = 0;
        for (String line : this.lines) {
            ++lineCounter;
            if (line.startsWith("SF:")) {
                coverage = this.parseSF(line, lineCounter);
                if (coverage == null || this.coverageByFile.put(coverage.getInputFile(), coverage) == null) continue;
                this.addProblem("Invalid SF. Duplicate file: " + coverage.getInputFile().toString(), lineCounter);
                continue;
            }
            if (line.startsWith("DA:")) {
                this.parseDA(coverage, line, lineCounter);
                continue;
            }
            if (!line.startsWith("BRDA:")) continue;
            this.parseBRDA(coverage, line, lineCounter);
        }
        return new ParsingResult(new ArrayList<CodeCoverage>(this.coverageByFile.values()), this.problems);
    }

    private CodeCoverage parseSF(String line, int lineCounter) {
        String filePath = line.substring("SF:".length());
        InputFile inputFile = this.resolveInputFile(filePath);
        if (inputFile == null) {
            this.addProblem("Invalid SF. File not found: " + filePath, lineCounter);
            return null;
        }
        return new CodeCoverage(inputFile);
    }

    private void parseDA(@Nullable CodeCoverage coverage, String line, int lineCounter) {
        if (coverage == null) {
            return;
        }
        String[] tokens = line.substring("DA:".length()).split(",");
        if (tokens.length < 2) {
            this.addProblem("Invalid DA. Syntax error", lineCounter);
        } else {
            try {
                int lineId = Integer.parseInt(tokens[0]);
                int executionCount = Integer.parseInt(tokens[1]);
                coverage.addLineHits(lineId, executionCount);
            }
            catch (NumberFormatException e) {
                this.addProblem("Invalid DA. Number format error", lineCounter);
            }
            catch (Exception e) {
                this.addProblem("Invalid DA. " + e.getMessage(), lineCounter);
            }
        }
    }

    private void parseBRDA(@Nullable CodeCoverage coverage, String line, int lineCounter) {
        if (coverage == null) {
            return;
        }
        String[] tokens = line.substring("BRDA:".length()).split(",");
        if (tokens.length < 4) {
            this.addProblem("Invalid BRDA. Syntax error", lineCounter);
        } else {
            try {
                int lineId = Integer.parseInt(tokens[0]);
                String branchId = tokens[1] + tokens[2];
                int taken = Math.max(0, Integer.parseInt(tokens[3]));
                coverage.addBranchHits(lineId, branchId, taken);
            }
            catch (NumberFormatException e) {
                this.addProblem("Invalid BRDA. Number format error", lineCounter);
            }
            catch (Exception e) {
                this.addProblem("Invalid BRDA. " + e.getMessage(), lineCounter);
            }
        }
    }

    private InputFile resolveInputFile(String filePath) {
        FilePredicate predicate;
        FileSystem fs = this.context.fileSystem();
        InputFile inputFile = fs.inputFile(predicate = fs.predicates().hasPath(filePath));
        if (inputFile == null) {
            inputFile = this.fileLocator.getInputFile(filePath);
        }
        return inputFile;
    }

    private void addProblem(String message, int lineCounter) {
        this.problems.add(this.reportFile.getPath() + ":" + lineCounter + ": " + message);
    }

    private static class LCOV {
        public static final String SF = "SF:";
        public static final String DA = "DA:";
        public static final String BRDA = "BRDA:";

        private LCOV() {
        }
    }

    public record ParsingResult(List<CodeCoverage> coverages, List<String> problems) {
    }
}

