/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.coverage;

import java.util.Map;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonarsource.rust.coverage.CodeCoverage;

public class CoverageUtils {
    private CoverageUtils() {
    }

    public static void saveCoverage(SensorContext context, CodeCoverage coverage) {
        NewCoverage newCoverage = context.newCoverage().onFile(coverage.getInputFile());
        for (Map.Entry<Integer, Integer> entry : coverage.getLineHits().entrySet()) {
            newCoverage.lineHits(entry.getKey().intValue(), entry.getValue().intValue());
        }
        for (Map.Entry<Integer, Object> entry : coverage.getBranchHits().entrySet()) {
            Integer line = entry.getKey();
            int conditions = ((Map)entry.getValue()).size();
            int coveredConditions = 0;
            for (Integer taken : ((Map)entry.getValue()).values()) {
                if (taken <= 0) continue;
                ++coveredConditions;
            }
            newCoverage.conditions(line.intValue(), conditions, coveredConditions);
            newCoverage.lineHits(line.intValue(), coverage.getLineHits().getOrDefault(line, 0) + coveredConditions);
        }
        newCoverage.save();
    }
}

