/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.coverage;

import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.fs.InputFile;

public class CodeCoverage {
    private final InputFile inputFile;
    private final Map<Integer, Integer> lineHits = new HashMap<Integer, Integer>();
    private final Map<Integer, Map<String, Integer>> branchHits = new HashMap<Integer, Map<String, Integer>>();

    public CodeCoverage(InputFile inputFile) {
        this.inputFile = inputFile;
    }

    public InputFile getInputFile() {
        return this.inputFile;
    }

    public Map<Integer, Integer> getLineHits() {
        return this.lineHits;
    }

    public void addLineHits(int line, int hits) {
        this.validateLineNumber(line);
        this.lineHits.merge(line, hits, Integer::sum);
    }

    public Map<Integer, Map<String, Integer>> getBranchHits() {
        return this.branchHits;
    }

    public void addBranchHits(int line, String branch, int taken) {
        this.validateLineNumber(line);
        this.branchHits.computeIfAbsent(line, k -> new HashMap()).merge(branch, taken, Integer::sum);
    }

    private void validateLineNumber(int line) {
        if (line < 1 || line > this.inputFile.lines()) {
            throw new IllegalStateException("Line number outside of file range: " + line);
        }
    }
}

