/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.coverage;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonarsource.rust.common.FileLocator;
import org.sonarsource.rust.common.ReportProvider;
import org.sonarsource.rust.coverage.CoberturaParser;
import org.sonarsource.rust.coverage.CodeCoverage;
import org.sonarsource.rust.coverage.CoverageUtils;
import org.sonarsource.rust.plugin.Telemetry;

public class CoberturaSensor
implements Sensor {
    public static final String COBERTURA_REPORT_PATHS = "sonar.rust.cobertura.reportPaths";
    private static final Logger LOG = LoggerFactory.getLogger(CoberturaSensor.class);

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Rust Cobertura Coverage").onlyOnLanguage("rust").onlyWhenConfiguration(config -> config.hasKey(COBERTURA_REPORT_PATHS));
    }

    public void execute(SensorContext context) {
        LOG.debug("Processing Cobertura coverage reports");
        Telemetry.reportCoverageFormat(context, "Cobertura");
        List<File> reportFiles = new ReportProvider("Cobertura", COBERTURA_REPORT_PATHS).getReportFiles(context);
        if (reportFiles.isEmpty()) {
            LOG.warn("No Cobertura report files found");
            return;
        }
        LOG.debug("Found {} Cobertura report files", (Object)reportFiles.size());
        FileSystem fs = context.fileSystem();
        FilePredicate predicate = fs.predicates().and(fs.predicates().hasType(InputFile.Type.MAIN), fs.predicates().hasLanguage("rust"));
        FileLocator fileLocator = new FileLocator(fs.inputFiles(predicate));
        ArrayList<CodeCoverage> coverages = new ArrayList<CodeCoverage>();
        for (File reportFile : reportFiles) {
            try {
                LOG.debug("Parsing Cobertura report: {}", (Object)reportFile);
                CoberturaParser parser = new CoberturaParser(context, fileLocator, reportFile.toPath().toString());
                CoberturaParser.ParsingResult parsingResult = parser.parse(Files.readString(reportFile.toPath()));
                List<String> problems = parsingResult.problems();
                if (!problems.isEmpty()) {
                    LOG.warn("Found {} problems in Cobertura report: {}. More details in verbose mode", (Object)problems.size(), (Object)reportFile);
                    for (String problem : problems) {
                        LOG.debug(problem);
                    }
                }
                coverages.addAll(parsingResult.coverages());
            }
            catch (Exception e) {
                LOG.error("Failed to parse Cobertura report: " + String.valueOf(reportFile), (Throwable)e);
            }
        }
        for (CodeCoverage coverage : coverages) {
            try {
                LOG.debug("Saving coverage for file: {}", (Object)coverage.getInputFile());
                CoverageUtils.saveCoverage(context, coverage);
                LOG.debug("Successfully saved coverage");
            }
            catch (Exception e) {
                LOG.warn("Failed to save coverage", (Throwable)e);
            }
        }
        LOG.debug("Processed Corbetura coverage reports");
    }
}

