/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.coverage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.sonarsource.rust.common.FileLocator;
import org.sonarsource.rust.coverage.CodeCoverage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CoberturaParser {
    private static final Pattern CONDITION_COVERAGE_PATTERN = Pattern.compile("([0-9.]+)% \\((\\d+)/(\\d+)\\)");
    private final SensorContext context;
    private final FileLocator fileLocator;
    private final String reportFilePath;
    private final Map<InputFile, CodeCoverage> coverageByFile = new HashMap<InputFile, CodeCoverage>();
    private final List<String> problems = new ArrayList<String>();

    public CoberturaParser(SensorContext context, FileLocator fileLocator, String reportFilePath) {
        this.context = context;
        this.fileLocator = fileLocator;
        this.reportFilePath = reportFilePath;
    }

    public ParsingResult parse(String content) {
        Document document = XmlFile.create(content).getDocument();
        this.processDocument(document);
        return new ParsingResult(new ArrayList<CodeCoverage>(this.coverageByFile.values()), this.problems);
    }

    private void processDocument(Document document) {
        NodeList classes = document.getElementsByTagName("class");
        for (int i = 0; i < classes.getLength(); ++i) {
            Node currentClass = classes.item(i);
            Node currentFileName = currentClass.getAttributes().getNamedItem("filename");
            if (currentFileName == null) {
                this.addProblem("Attribute 'filename' not found on 'class' element", currentClass);
                continue;
            }
            InputFile currentInputFile = this.resolveInputFile(currentFileName.getNodeValue());
            if (currentInputFile == null) {
                this.addProblem("Input file not found for path: %s".formatted(currentFileName.getNodeValue()), currentClass);
                continue;
            }
            CodeCoverage coverage = new CodeCoverage(currentInputFile);
            this.processClass(coverage, currentClass);
            this.coverageByFile.put(currentInputFile, coverage);
        }
    }

    private void processClass(CodeCoverage coverage, Node classNode) {
        NodeList lines = this.getLines(classNode);
        if (lines == null) {
            return;
        }
        for (int i = 0; i < lines.getLength(); ++i) {
            Node line = lines.item(i);
            if (!"line".equals(line.getNodeName())) continue;
            this.processLine(coverage, line);
        }
    }

    @CheckForNull
    private NodeList getLines(Node classNode) {
        NodeList children = classNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equals("lines")) continue;
            return children.item(i).getChildNodes();
        }
        return null;
    }

    private void processLine(CodeCoverage coverage, Node line) {
        Optional<Integer> lineNumber = this.extractNumber(line, "number");
        Optional<Integer> hits = this.extractNumber(line, "hits");
        if (lineNumber.isEmpty() || hits.isEmpty()) {
            return;
        }
        coverage.addLineHits(lineNumber.get(), hits.get());
        boolean isBranch = Optional.ofNullable(line.getAttributes().getNamedItem("branch")).map(node -> node.getNodeValue().equals("true")).orElse(false);
        if (isBranch) {
            this.processConditionCoverage(coverage, line, lineNumber.get());
        }
    }

    private Optional<Integer> extractNumber(Node node, String attributeName) {
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        if (attribute == null) {
            this.addProblem("Attribute '%s' not found on '%s' element".formatted(attributeName, node.getNodeName()), node);
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(attribute.getNodeValue()));
        }
        catch (NumberFormatException ex) {
            this.addProblem("Invalid number format for attribute '%s' on '%s' element".formatted(attributeName, node.getNodeName()), node);
            return Optional.empty();
        }
    }

    private void processConditionCoverage(CodeCoverage coverage, Node line, int lineNumber) {
        int total;
        Node coverageAttr = line.getAttributes().getNamedItem("condition-coverage");
        if (coverageAttr == null) {
            this.addProblem("Attribute 'condition-coverage' not found on 'line' element", line);
            return;
        }
        Matcher matcher = CONDITION_COVERAGE_PATTERN.matcher(coverageAttr.getNodeValue());
        if (!matcher.matches()) {
            this.addProblem("Invalid condition coverage format", line);
            return;
        }
        int taken = Integer.parseInt(matcher.group(2));
        if (taken > (total = Integer.parseInt(matcher.group(3)))) {
            this.addProblem("Invalid condition coverage: taken count is greater than total count", line);
            return;
        }
        for (int i = 0; i < total; ++i) {
            coverage.addBranchHits(lineNumber, Integer.toString(i), i < taken ? 1 : 0);
        }
    }

    @CheckForNull
    private InputFile resolveInputFile(String filePath) {
        FilePredicate predicate;
        FileSystem fs = this.context.fileSystem();
        InputFile inputFile = fs.inputFile(predicate = fs.predicates().hasPath(filePath));
        if (inputFile == null) {
            inputFile = this.fileLocator.getInputFile(filePath);
        }
        return inputFile;
    }

    private void addProblem(String message, Node node) {
        XmlTextRange textRange = XmlFile.nodeLocation(node);
        this.problems.add("%s:%d:%d %s".formatted(this.reportFilePath, textRange.getStartLine(), textRange.getStartColumn(), message));
    }

    public record ParsingResult(List<CodeCoverage> coverages, List<String> problems) {
    }
}

