/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(StreamConsumer.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("stream-consumer");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, e) -> LOG.error("Error in thread " + t.getName(), e));
        return thread;
    });

    StreamConsumer() {
    }

    void consumeStream(InputStream inputStream, Consumer<String> consumer) {
        this.executorService.execute(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                reader.lines().forEach(consumer);
            }
            catch (IOException e) {
                LOG.error("Error while reading stream", (Throwable)e);
            }
        });
    }

    void await() throws InterruptedException {
        this.executorService.shutdown();
        if (!this.executorService.awaitTermination(5L, TimeUnit.MINUTES)) {
            LOG.error("External process stream consumer timed out");
            this.executorService.shutdownNow();
        }
    }
}

