/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.common;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.analyzer.commons.FileProvider;

public class ReportProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ReportProvider.class);
    private final String kind;
    private final String property;

    public ReportProvider(String kind, String property) {
        this.kind = kind;
        this.property = property;
    }

    public List<File> getReportFiles(SensorContext context) {
        String[] reportPaths = context.config().getStringArray(this.property);
        if (reportPaths.length == 0) {
            LOG.debug("No {} report paths were provided", (Object)this.kind);
            return List.of();
        }
        ArrayList<File> reportFiles = new ArrayList<File>();
        for (String reportPath : reportPaths) {
            LOG.debug("Attempting to resolve {} report path: {}", (Object)this.kind, (Object)reportPath);
            File baseDir = context.fileSystem().baseDir();
            File reportFile = new File(reportPath);
            if (!reportFile.isAbsolute()) {
                reportFile = new File(baseDir, reportPath);
            }
            if (reportFile.isFile()) {
                LOG.debug("Found {} report file: {}", (Object)this.kind, (Object)reportFile);
                reportFiles.add(reportFile);
                continue;
            }
            LOG.debug("{} report path is not a file: {}", (Object)this.kind, (Object)reportFile);
            LOG.debug("Attempting to resolve {} report pattern: {}", (Object)this.kind, (Object)reportPath);
            FileProvider provider = new FileProvider(baseDir, reportPath);
            List<File> matchingFiles = provider.getMatchingFiles();
            if (matchingFiles.isEmpty()) {
                LOG.debug("No {} report files matched the pattern: {}", (Object)this.kind, (Object)reportPath);
                continue;
            }
            LOG.debug("Found {} report files: {}", (Object)this.kind, matchingFiles);
            reportFiles.addAll(matchingFiles);
        }
        return reportFiles;
    }
}

