/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonarsource.rust.common.StreamConsumer;

public class ProcessWrapper {
    private Process process;
    private StreamConsumer consumer;

    public void start(List<String> command, @Nullable Path workDir, @Nullable Consumer<String> stdOut, @Nullable Consumer<String> stdErr) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command).directory(workDir != null ? workDir.toFile() : null);
        this.process = pb.start();
        this.consumer = new StreamConsumer();
        if (stdOut != null) {
            this.consumer.consumeStream(this.process.getInputStream(), stdOut);
        }
        if (stdErr != null) {
            this.consumer.consumeStream(this.process.getErrorStream(), stdErr);
        }
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public int waitFor() throws InterruptedException {
        int exitValue = this.process.waitFor();
        this.consumer.await();
        return exitValue;
    }

    public void destroyForcibly() {
        this.process.destroyForcibly();
        try {
            this.consumer.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for the process to finish", e);
        }
    }
}

