/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.common;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;

public class FileLocator {
    private final ReversePathTree tree = new ReversePathTree();

    public FileLocator(Iterable<InputFile> inputFiles) {
        inputFiles.forEach(inputFile -> {
            String[] path = inputFile.relativePath().split("/");
            this.tree.index((InputFile)inputFile, path);
        });
    }

    public InputFile getInputFile(String filePath) {
        String sanitizedPath = PathUtils.sanitize((String)filePath);
        if (sanitizedPath == null) {
            return null;
        }
        String[] pathElements = sanitizedPath.split("/");
        return this.tree.getFileWithSuffix(pathElements);
    }

    private static class ReversePathTree {
        private Node root = new Node();

        private ReversePathTree() {
        }

        void index(InputFile inputFile, String[] path) {
            Node currentNode = this.root;
            for (int i = path.length - 1; i >= 0; --i) {
                currentNode = currentNode.children.computeIfAbsent(path[i], e -> new Node());
            }
            currentNode.file = inputFile;
        }

        InputFile getFileWithSuffix(String[] path) {
            Node currentNode = this.root;
            for (int i = path.length - 1; i >= 0; --i) {
                currentNode = currentNode.children.get(path[i]);
                if (currentNode != null) continue;
                return null;
            }
            return ReversePathTree.getFirstLeaf(currentNode);
        }

        private static InputFile getFirstLeaf(Node node) {
            while (!node.children.isEmpty()) {
                node = node.children.values().iterator().next();
            }
            return node.file;
        }

        static class Node {
            final Map<String, Node> children = new LinkedHashMap<String, Node>();
            InputFile file = null;

            Node() {
            }
        }
    }
}

