/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.clippy;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonarsource.rust.clippy.ClippyDiagnostic;
import org.sonarsource.rust.clippy.ClippySpan;

class ClippyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClippyUtils.class);
    private static final Gson GSON = new Gson();

    private ClippyUtils() {
    }

    static List<ClippyDiagnostic> parse(File reportFile) {
        List<ClippyDiagnostic> list;
        block9: {
            BufferedReader reader = Files.newBufferedReader(reportFile.toPath());
            try {
                Stream<String> lines = reader.lines();
                list = ClippyUtils.parse(lines).toList();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read Clippy report: " + String.valueOf(reportFile), e);
                }
                catch (JsonSyntaxException e) {
                    throw new IllegalStateException("Failed to parse Clippy report: " + String.valueOf(reportFile), e);
                }
            }
            reader.close();
        }
        return list;
    }

    static Stream<ClippyDiagnostic> parse(Stream<String> lines) {
        return lines.filter(line -> {
            if (line.startsWith("{")) {
                return true;
            }
            LOG.debug("Ignoring line: {}", line);
            return false;
        }).map(line -> GSON.fromJson((String)line, ClippyDiagnostic.class)).filter(ClippyUtils::isClippyDiagnostic);
    }

    private static boolean isClippyDiagnostic(@Nullable ClippyDiagnostic diagnostic) {
        return diagnostic != null && diagnostic.manifest_path() != null && diagnostic.message() != null && diagnostic.message().code() != null && diagnostic.message().code().code() != null && diagnostic.message().code().code().startsWith("clippy");
    }

    static NewIssueLocation diagnosticToLocation(NewIssueLocation location, ClippyDiagnostic diagnostic, SensorContext context, Path workDir) {
        List<ClippySpan> spans = diagnostic.message().spans();
        if (spans.isEmpty()) {
            throw new IllegalStateException("Empty spans");
        }
        ClippySpan span = spans.get(0);
        String fileName = span.file_name();
        Path baseDir = context.fileSystem().baseDir().toPath();
        if (!baseDir.equals(workDir)) {
            fileName = workDir.resolve(fileName).toString();
        }
        FilePredicate predicates = context.fileSystem().predicates().hasPath(fileName);
        InputFile inputFile = context.fileSystem().inputFile(predicates);
        if (inputFile == null) {
            return null;
        }
        location.on((InputComponent)inputFile).at(inputFile.newRange(span.line_start(), span.column_start() - 1, span.line_end(), span.column_end() - 1));
        return location;
    }
}

