/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.clippy;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.rust.cargo.CargoManifestProvider;
import org.sonarsource.rust.clippy.ClippyDiagnostic;
import org.sonarsource.rust.clippy.ClippyPrerequisite;
import org.sonarsource.rust.clippy.ClippyRunner;
import org.sonarsource.rust.clippy.ClippyUtils;
import org.sonarsource.rust.plugin.AnalysisWarningsWrapper;
import org.sonarsource.rust.plugin.RustRulesDefinition;
import org.sonarsource.rust.plugin.Telemetry;

public class ClippySensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(ClippySensor.class);
    public static final String CLIPPY_ANALYSIS_ENABLED = "sonar.rust.clippy.enabled";
    public static final String CLIPPY_OFFLINE = "sonar.rust.clippy.offline";
    private final ClippyPrerequisite clippyPrerequisite;
    private final ClippyRunner clippy;
    private final AnalysisWarningsWrapper analysisWarnings;

    public ClippySensor() {
        this(new ClippyPrerequisite(), new ClippyRunner(), new AnalysisWarningsWrapper());
    }

    ClippySensor(ClippyPrerequisite clippyPrerequisite, ClippyRunner clippy, AnalysisWarningsWrapper analysisWarnings) {
        this.clippyPrerequisite = clippyPrerequisite;
        this.clippy = clippy;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Clippy").onlyWhenConfiguration(config -> config.getBoolean(CLIPPY_ANALYSIS_ENABLED).orElse(true)).onlyOnLanguage("rust");
    }

    public void execute(SensorContext context) {
        List<File> manifests;
        if (!context.config().getBoolean(CLIPPY_ANALYSIS_ENABLED).orElse(true).booleanValue()) {
            LOG.debug("Clippy analysis is disabled");
            return;
        }
        boolean offlineMode = context.config().getBoolean(CLIPPY_OFFLINE).orElse(false);
        if (offlineMode) {
            LOG.debug("Clippy running in offline mode. Use `cargo fetch` to make sure all prerequisites are available.");
        }
        if ((manifests = CargoManifestProvider.getManifests(context)).isEmpty()) {
            String msg = "No Cargo manifest found, skipping Clippy analysis";
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
            ClippySensor.failFastCheck(context, new IllegalStateException(msg));
            return;
        }
        Path baseDir = context.fileSystem().baseDir().toPath();
        Telemetry.reportAnalyzerClippyUsage(context);
        try {
            ClippyPrerequisite.ToolVersions versions = this.clippyPrerequisite.check(baseDir);
            Telemetry.reportClippyVersion(context, versions.clippyVersion());
        }
        catch (Exception e) {
            LOG.error("Failed to check Clippy prerequisites", (Throwable)e);
            this.analysisWarnings.addUnique("Failed to check Clippy prerequisites. See logs for details.");
            ClippySensor.failFastCheck(context, e);
            return;
        }
        List<String> lints = context.activeRules().findByRepository("rust").stream().map(rule -> RustRulesDefinition.ruleKeyToLintId(rule.ruleKey().rule())).filter(Objects::nonNull).toList();
        try {
            for (File manifest : manifests) {
                Path manifestPath = manifest.toPath();
                Telemetry.reportManifestInfo(context, manifestPath);
                Path workDir = manifestPath.getParent();
                this.clippy.run(workDir, lints, diagnostic -> {
                    try {
                        ClippySensor.saveIssue(context, diagnostic, workDir);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to save Clippy issue: {}", diagnostic, (Object)e);
                    }
                }, offlineMode);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to run Clippy", (Throwable)e);
            this.analysisWarnings.addUnique("Failed to run Clippy. See logs for details.");
            ClippySensor.failFastCheck(context, e);
        }
    }

    private static void failFastCheck(SensorContext sensorContext, Exception ex) {
        if (sensorContext.config().getBoolean("sonar.internal.analysis.rust.failFast").orElse(false).booleanValue()) {
            throw new IllegalStateException("Analysis failed", ex);
        }
    }

    private static void saveIssue(SensorContext context, ClippyDiagnostic diagnostic, Path workDir) {
        LOG.debug("Saving Clippy diagnostic: {}", (Object)diagnostic);
        String lintId = diagnostic.lintId();
        String ruleKey = RustRulesDefinition.lintIdToRuleKey(lintId);
        if (ruleKey == null) {
            LOG.debug("No rule key found for Clippy lint: {}", (Object)lintId);
            return;
        }
        NewIssue issue = context.newIssue().forRule(RuleKey.of((String)"rust", (String)ruleKey));
        NewIssueLocation location = ClippyUtils.diagnosticToLocation(issue.newLocation(), diagnostic, context, workDir);
        if (location == null) {
            LOG.debug("No InputFile found for Clippy diagnostic: {}", (Object)diagnostic);
            return;
        }
        String message = RustRulesDefinition.lintIdToMessage(lintId);
        if (message == null) {
            LOG.debug("No message found for Clippy lint: {}", (Object)lintId);
            return;
        }
        location.message(message);
        issue.at(location);
        issue.save();
    }
}

