/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.clippy;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.rust.clippy.ClippyDiagnostic;
import org.sonarsource.rust.clippy.ClippyUtils;
import org.sonarsource.rust.common.ProcessWrapper;

public class ClippyRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ClippyRunner.class);
    private final ProcessWrapper processWrapper;

    ClippyRunner() {
        this(new ProcessWrapper());
    }

    ClippyRunner(ProcessWrapper processWrapper) {
        this.processWrapper = processWrapper;
    }

    public void run(Path workDir, List<String> lints, Consumer<ClippyDiagnostic> consumer, boolean offline) {
        List<String> command = ClippyRunner.buildCommand(lints, offline);
        LOG.debug("Running Clippy: {}", command);
        try {
            this.processWrapper.start(command, workDir, output -> ClippyRunner.readOutput(output, consumer), arg_0 -> ((Logger)LOG).warn(arg_0));
            int exitValue = this.processWrapper.waitFor();
            if (exitValue != 0) {
                throw new IllegalStateException("Clippy failed with exit code " + exitValue);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Clippy was interrupted", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to run Clippy ", e);
        }
    }

    private static List<String> buildCommand(List<String> lints, boolean offline) {
        ArrayList<String> cmd = new ArrayList<String>(List.of("cargo", "clippy", "--quiet", "--message-format=json"));
        if (offline) {
            cmd.add("--offline");
        }
        cmd.addAll(List.of("--", "-A", "clippy::all"));
        lints.stream().map(lint -> String.format("-W%s", lint)).forEach(cmd::add);
        return cmd;
    }

    private static void readOutput(String output, Consumer<ClippyDiagnostic> consumer) {
        ClippyUtils.parse(Stream.of(output)).forEach(consumer);
    }
}

