/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.clippy;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.rust.clippy.ClippyDiagnostic;
import org.sonarsource.rust.clippy.ClippyRulesDefinition;
import org.sonarsource.rust.clippy.ClippyUtils;
import org.sonarsource.rust.common.ReportProvider;
import org.sonarsource.rust.plugin.Telemetry;

public class ClippyReportSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(ClippyReportSensor.class);
    public static final String CLIPPY_REPORT_PATHS = "sonar.rust.clippyReport.reportPaths";

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Clippy Report Import").onlyOnLanguage("rust").onlyWhenConfiguration(config -> config.hasKey(CLIPPY_REPORT_PATHS));
    }

    public void execute(SensorContext context) {
        LOG.debug("Processing Clippy reports");
        Telemetry.reportExternalClippyUsage(context);
        ReportProvider reportProvider = new ReportProvider("Clippy", CLIPPY_REPORT_PATHS);
        List<File> reportFiles = reportProvider.getReportFiles(context);
        if (reportFiles.isEmpty()) {
            LOG.warn("No Clippy report files found");
            return;
        }
        LOG.debug("Found {} Clippy report files", (Object)reportFiles.size());
        ArrayList<ClippyDiagnostic> diagnostics = new ArrayList<ClippyDiagnostic>();
        for (File reportFile : reportFiles) {
            try {
                LOG.debug("Parsing Clippy report: {}", (Object)reportFile);
                List<ClippyDiagnostic> reportDiagnostics = ClippyUtils.parse(reportFile);
                diagnostics.addAll(reportDiagnostics);
                LOG.debug("Successfully parsed Clippy report");
            }
            catch (Exception e) {
                LOG.error("Failed to parse Clippy report", (Throwable)e);
            }
        }
        for (ClippyDiagnostic diagnostic : diagnostics) {
            try {
                LOG.debug("Saving Clippy diagnostic: {}", (Object)diagnostic);
                Path manifestDir = Path.of(diagnostic.manifest_path(), new String[0]).getParent();
                ClippyReportSensor.saveIssue(context, diagnostic, manifestDir);
                LOG.debug("Successfully saved Clippy diagnostic");
            }
            catch (Exception e) {
                LOG.warn("Failed to save Clippy diagnostic. {}", (Object)e.getMessage());
            }
        }
        LOG.debug("Processed Clippy reports");
    }

    private static void saveIssue(SensorContext context, ClippyDiagnostic diagnostic, Path baseDir) {
        String ruleId = diagnostic.lintId().substring("clippy::".length());
        ExternalRuleLoader loader = ClippyRulesDefinition.loader();
        if (!loader.ruleKeys().contains(ruleId)) {
            throw new IllegalStateException("Unknown rule: " + ruleId);
        }
        NewExternalIssue issue = context.newExternalIssue().engineId("clippy").ruleId(ruleId).type(loader.ruleType(ruleId)).severity(loader.ruleSeverity(ruleId)).remediationEffortMinutes(loader.ruleConstantDebtMinutes(ruleId));
        NewIssueLocation location = ClippyUtils.diagnosticToLocation(issue.newLocation(), diagnostic, context, baseDir);
        if (location == null) {
            throw new IllegalStateException("Unknown file: " + diagnostic.message().spans().get(0).file_name());
        }
        location.message(diagnostic.message().message());
        issue.at(location);
        issue.save();
    }
}

