/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.clippy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.rust.common.ProcessWrapper;

public class ClippyPrerequisite {
    private static final Logger LOG = LoggerFactory.getLogger(ClippyPrerequisite.class);
    private final ProcessWrapper processWrapper;

    public ClippyPrerequisite() {
        this(new ProcessWrapper());
    }

    public ClippyPrerequisite(ProcessWrapper processWrapper) {
        this.processWrapper = processWrapper;
    }

    public ToolVersions check(Path workDir) {
        String cargoVersion = this.checkVersion(List.of("cargo", "--version"), "Cargo", workDir);
        String clippyVersion = this.checkVersion(List.of("cargo", "clippy", "--version"), "Clippy", workDir);
        return new ToolVersions(cargoVersion, clippyVersion);
    }

    private String checkVersion(List<String> command, String prerequisite, Path workDir) {
        String string;
        LOG.debug("Checking {} version", (Object)prerequisite);
        this.processWrapper.start(command, workDir, null, arg_0 -> ((Logger)LOG).warn(arg_0));
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.processWrapper.getInputStream()));
        try {
            String version = reader.readLine();
            if (version == null || version.isBlank()) {
                throw new IllegalStateException("Unable to retrieve " + prerequisite + " version");
            }
            LOG.debug("{} version: {}", (Object)prerequisite, (Object)version);
            string = version;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to check " + prerequisite + " version", e);
            }
        }
        reader.close();
        return string;
    }

    public record ToolVersions(String cargoVersion, String clippyVersion) {
    }
}

