/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.rust.cargo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.analyzer.commons.FileProvider;

public class CargoManifestProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CargoManifestProvider.class);
    private static final String CARGO_MANIFEST_NAME = "Cargo.toml";
    public static final String CARGO_MANIFEST_PATHS = "sonar.rust.cargo.manifestPaths";

    private CargoManifestProvider() {
    }

    public static List<File> getManifests(SensorContext context) {
        LOG.debug("Looking for Cargo manifests");
        List<ProjectRootProvider> strategies = List.of(new PropertyBasedProvider(), new ProjectRootProvider());
        for (ManifestProviderStrategy manifestProviderStrategy : strategies) {
            List<File> manifests = manifestProviderStrategy.getManifests(context);
            if (manifests.isEmpty()) continue;
            LOG.debug("Found Cargo manifests: {}", manifests);
            return manifests;
        }
        LOG.debug("No Cargo manifest found");
        return List.of();
    }

    private static class PropertyBasedProvider
    implements ManifestProviderStrategy {
        private PropertyBasedProvider() {
        }

        @Override
        public List<File> getManifests(SensorContext context) {
            LOG.debug("Looking for Cargo manifest paths using {}", (Object)CargoManifestProvider.CARGO_MANIFEST_PATHS);
            String[] manifestPatterns = context.config().getStringArray(CargoManifestProvider.CARGO_MANIFEST_PATHS);
            if (manifestPatterns.length == 0) {
                LOG.debug("No Cargo manifest paths were provided");
                return List.of();
            }
            ArrayList<File> manifests = new ArrayList<File>();
            for (String manifestPattern : manifestPatterns) {
                LOG.debug("Attempting to resolve Cargo manifest path: {}", (Object)manifestPattern);
                File baseDir = context.fileSystem().baseDir();
                File manifest = new File(manifestPattern);
                if (!manifest.isAbsolute()) {
                    manifest = new File(baseDir, manifestPattern);
                }
                if (manifest.isFile()) {
                    manifests.add(manifest);
                    continue;
                }
                LOG.debug("Cargo manifest path does not exist: {}", (Object)manifest);
                LOG.debug("Attempting to resolve Cargo manifest pattern: {}", (Object)manifestPattern);
                FileProvider provider = new FileProvider(baseDir, manifestPattern);
                List<File> matchingFiles = provider.getMatchingFiles();
                if (matchingFiles.isEmpty()) {
                    LOG.debug("No Cargo manifest matched the pattern: {}", (Object)manifestPattern);
                    continue;
                }
                LOG.debug("Found Cargo manifests: {}", matchingFiles);
                manifests.addAll(matchingFiles);
            }
            return manifests;
        }
    }

    private static class ProjectRootProvider
    implements ManifestProviderStrategy {
        private ProjectRootProvider() {
        }

        @Override
        public List<File> getManifests(SensorContext context) {
            LOG.debug("Looking for Cargo manifest at the root of the project");
            File baseDir = context.fileSystem().baseDir();
            File manifest = baseDir.toPath().resolve(CargoManifestProvider.CARGO_MANIFEST_NAME).toFile();
            if (manifest.exists()) {
                LOG.debug("Found Cargo manifest: {}", (Object)manifest);
                return List.of(manifest);
            }
            return List.of();
        }
    }

    private static interface ManifestProviderStrategy {
        public List<File> getManifests(SensorContext var1);
    }
}

