/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.text.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.text.api.TextCheck;

@Rule(key="S7628")
public class TagBlockCheck
extends TextCheck {
    public static final String MESSAGE_FORMAT = "This line contains the hidden text \"%s\" starting at column %d. Make sure that using Unicode tag blocks is intentional and safe here.";
    private static final int BLACK_FLAG_EMOJI_CODE_POINT = 127988;
    private static final int CANCEL_TAG_CODE_POINT = 917631;
    private DurationStatistics durationStatistics;

    public void initialize(DurationStatistics durationStatistics) {
        this.durationStatistics = durationStatistics;
    }

    @Override
    public void analyze(InputFileContext ctx) {
        this.durationStatistics.timed(this.getRuleKey().rule() + "::total", new TagBlockFileAnalyzer(ctx)::analyze);
    }

    private static boolean isTag(int charCodePoint) {
        return charCodePoint >= 917536 && charCodePoint <= 917631;
    }

    private static boolean isBlackFlagEmoji(int charCodePoint) {
        return charCodePoint == 127988;
    }

    private static char convertTagCharToChar(int tagCharCodePoint) {
        int charCodePoint = tagCharCodePoint - 917504;
        return (char)charCodePoint;
    }

    private class TagBlockFileAnalyzer {
        private final InputFileContext ctx;
        private List<Integer> tagSequence;
        private Integer tagSequenceStartIndex;
        private Integer currentColumnNumber;

        public TagBlockFileAnalyzer(InputFileContext ctx) {
            this.ctx = ctx;
        }

        public void analyze() {
            List<String> lines = this.ctx.lines();
            for (int lineOffset = 0; lineOffset < lines.size(); ++lineOffset) {
                this.checkLine(this.ctx, lines.get(lineOffset), lineOffset + 1);
            }
        }

        private void checkLine(InputFileContext ctx, String lineContent, int lineNumber) {
            this.currentColumnNumber = 1;
            int i = 0;
            while (i < lineContent.length()) {
                Integer n;
                int currentCodePoint = lineContent.codePointAt(i);
                if (TagBlockCheck.isBlackFlagEmoji(currentCodePoint)) {
                    i = this.getIndexAfterFlagEmoji(lineContent, i);
                    n = this.currentColumnNumber;
                    this.currentColumnNumber = this.currentColumnNumber + 1;
                    continue;
                }
                if (TagBlockCheck.isTag(currentCodePoint)) {
                    if (!this.isTagSequenceOngoing()) {
                        this.initTagSequence(i);
                    }
                    this.tagSequence.add(currentCodePoint);
                } else if (this.isTagSequenceOngoing()) {
                    this.flushTagSequence(ctx, lineNumber);
                }
                i += Character.charCount(lineContent.codePointAt(i));
                n = this.currentColumnNumber;
                this.currentColumnNumber = this.currentColumnNumber + 1;
            }
            if (this.isTagSequenceOngoing()) {
                this.flushTagSequence(ctx, lineNumber);
            }
        }

        private void initTagSequence(int startIndex) {
            this.tagSequenceStartIndex = startIndex;
            if (this.tagSequence == null) {
                this.tagSequence = new ArrayList<Integer>();
            }
        }

        private boolean isTagSequenceOngoing() {
            return this.tagSequenceStartIndex != null;
        }

        private int getIndexAfterFlagEmoji(String text, int startIndex) {
            int currentPosition;
            int codePoint;
            for (currentPosition = startIndex + Character.charCount(127988); currentPosition < text.length() && TagBlockCheck.isTag(codePoint = text.codePointAt(currentPosition)); currentPosition += Character.charCount(codePoint)) {
                if (codePoint != 917631) continue;
                currentPosition += Character.charCount(917631);
                break;
            }
            return currentPosition;
        }

        private void flushTagSequence(InputFileContext ctx, int lineNumber) {
            String hiddenText = this.tagSequence.stream().map(TagBlockCheck::convertTagCharToChar).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
            if (!hiddenText.isBlank() && hiddenText.length() > 1) {
                int tagSequenceStartColumnNumber = this.currentColumnNumber - this.tagSequence.size();
                ctx.reportTextIssue(TagBlockCheck.this.getRuleKey(), lineNumber, TagBlockCheck.MESSAGE_FORMAT.formatted(hiddenText, tagSequenceStartColumnNumber));
            }
            this.tagSequence.clear();
            this.tagSequenceStartIndex = null;
        }
    }
}

