/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.text.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.text.api.TextCheck;

@Rule(key="S6389")
public class BIDICharacterCheck
extends TextCheck {
    public static final String MESSAGE_FORMAT = "This line contains a bidirectional character in column %d. Make sure that using bidirectional characters is safe here.";
    private static final List<Character> BIDI_FORMATTING_CHARS = List.of(Character.valueOf('\u202a'), Character.valueOf('\u202b'), Character.valueOf('\u202d'), Character.valueOf('\u202e'));
    private static final List<Character> BIDI_ISOLATE_CHARS = List.of(Character.valueOf('\u2066'), Character.valueOf('\u2067'), Character.valueOf('\u2068'));
    private static final List<Character> BIDI_CHARS = new ArrayList<Character>(BIDI_FORMATTING_CHARS);
    private static final char PDF = '\u202c';
    private static final char PDI = '\u2069';
    private static final Predicate<String> ANDROID_I18N_FILE_PREDICATE;
    private DurationStatistics durationStatistics;

    public void initialize(DurationStatistics durationStatistics) {
        this.durationStatistics = durationStatistics;
    }

    @Override
    public void analyze(InputFileContext ctx) {
        this.durationStatistics.timed(this.getRuleKey().rule() + "::total", () -> this.analyzeFile(ctx));
    }

    private void analyzeFile(InputFileContext ctx) {
        if (BIDICharacterCheck.isAndroidI18nFile(ctx)) {
            return;
        }
        List<String> lines = ctx.lines();
        for (int lineOffset = 0; lineOffset < lines.size(); ++lineOffset) {
            this.checkLine(ctx, lines.get(lineOffset), lineOffset + 1);
        }
    }

    static boolean isAndroidI18nFile(InputFileContext ctx) {
        InputFile inputFile = ctx.getInputFile();
        return "strings.xml".equals(inputFile.filename()) && ANDROID_I18N_FILE_PREDICATE.test(inputFile.uri().getPath());
    }

    private void checkLine(InputFileContext ctx, String lineContent, int lineNumber) {
        for (Character bidiChar : BIDI_CHARS) {
            if (lineContent.indexOf(bidiChar.charValue()) < 0) continue;
            this.checkLineBIDIChars(ctx, lineContent, lineNumber);
            return;
        }
    }

    private void checkLineBIDIChars(InputFileContext ctx, String lineContent, int lineNumber) {
        ArrayDeque<Integer> unclosedFormattingColumns = new ArrayDeque<Integer>();
        ArrayDeque<Integer> unclosedIsolateColumns = new ArrayDeque<Integer>();
        for (int i = 0; i < lineContent.length(); ++i) {
            char currentChar = lineContent.charAt(i);
            if (BIDI_FORMATTING_CHARS.contains(Character.valueOf(currentChar))) {
                unclosedFormattingColumns.push(i);
                continue;
            }
            if (BIDI_ISOLATE_CHARS.contains(Character.valueOf(currentChar))) {
                unclosedIsolateColumns.push(i);
                continue;
            }
            if (currentChar == '\u202c' && !unclosedFormattingColumns.isEmpty()) {
                unclosedFormattingColumns.pop();
                continue;
            }
            if (currentChar != '\u2069' || unclosedIsolateColumns.isEmpty()) continue;
            unclosedIsolateColumns.pop();
        }
        this.maybeReportOnFirstColumn(ctx, lineNumber, unclosedFormattingColumns, unclosedIsolateColumns);
    }

    private void maybeReportOnFirstColumn(InputFileContext ctx, int lineNumber, Deque<Integer> unclosedFormattingColumns, Deque<Integer> unclosedIsolateColumns) {
        if (unclosedFormattingColumns.isEmpty() && unclosedIsolateColumns.isEmpty()) {
            return;
        }
        int columnToReport = 0;
        columnToReport = !unclosedFormattingColumns.isEmpty() && !unclosedIsolateColumns.isEmpty() ? (unclosedFormattingColumns.getFirst() < unclosedIsolateColumns.getFirst() ? unclosedFormattingColumns.getFirst().intValue() : unclosedIsolateColumns.getFirst().intValue()) : (!unclosedFormattingColumns.isEmpty() ? unclosedFormattingColumns.getFirst().intValue() : unclosedIsolateColumns.getFirst().intValue());
        ctx.reportTextIssue(this.getRuleKey(), lineNumber, String.format(MESSAGE_FORMAT, columnToReport + 1));
    }

    static {
        BIDI_CHARS.addAll(BIDI_ISOLATE_CHARS);
        ANDROID_I18N_FILE_PREDICATE = Pattern.compile("res/values-[a-zA-Z\\-]+/strings.xml$").asPredicate();
    }
}

