/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.ahocorasick.trie.PayloadTrie;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.secrets.api.SecretsSpecificationLoader;
import org.sonar.plugins.secrets.configuration.model.Rule;
import org.sonar.plugins.secrets.configuration.model.matching.filter.FileFilter;
import org.sonar.plugins.secrets.configuration.model.matching.filter.PreModule;

public final class ContentPreFilterUtils {
    private ContentPreFilterUtils() {
    }

    public static <T extends Check> Map<String, Collection<T>> getChecksByContentPreFilters(Iterable<T> checks, SecretsSpecificationLoader specLoader) {
        HashMap checksByPreFilters = new HashMap();
        for (Check check : checks) {
            List<Rule> rules = specLoader.getRulesForKey(check.getRuleKey().rule());
            if (!ContentPreFilterUtils.hasOptimizableContentPrefilters(rules)) continue;
            for (Rule rule : rules) {
                Optional<FileFilter> include = Optional.ofNullable(rule.getDetection().getPre()).map(PreModule::getInclude);
                if (include.isEmpty()) continue;
                List<String> content = include.get().getContent();
                content.forEach(preFilter -> checksByPreFilters.computeIfAbsent((String)preFilter, k -> new HashSet()).add(check));
            }
        }
        return checksByPreFilters;
    }

    public static <T extends Check> PayloadTrie<Collection<T>> getPreprocessedTrie(Map<String, Collection<T>> checksByPreFilters) {
        PayloadTrie.PayloadTrieBuilder<Collection<T>> trieBuilder = PayloadTrie.builder();
        for (Map.Entry<String, Collection<T>> entry : checksByPreFilters.entrySet()) {
            String preFilter = entry.getKey().toLowerCase(Locale.ROOT);
            Collection<T> checks = entry.getValue();
            trieBuilder.addKeyword(preFilter, checks);
        }
        return trieBuilder.ignoreCase().build();
    }

    public static boolean hasOptimizableContentPrefilters(Collection<Rule> rules) {
        return rules.stream().allMatch(ContentPreFilterUtils::hasIncludeContentPreFilter);
    }

    private static boolean hasIncludeContentPreFilter(Rule rule) {
        PreModule pre = rule.getDetection().getPre();
        if (pre == null) {
            return false;
        }
        FileFilter include = pre.getInclude();
        if (include == null) {
            return false;
        }
        List<String> content = include.getContent();
        return !content.isEmpty();
    }
}

