/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ahocorasick.trie.PayloadEmit;
import org.ahocorasick.trie.PayloadTrie;
import org.ahocorasick.trie.handler.PayloadEmitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.common.analyzer.TextAndSecretsAnalyzer;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.secrets.api.SecretsSpecificationLoader;
import org.sonar.plugins.secrets.api.SpecificationBasedCheck;
import org.sonar.plugins.secrets.utils.ContentPreFilterUtils;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="MODULE")
public class CheckContainer {
    private static final Logger LOG = LoggerFactory.getLogger(CheckContainer.class);
    private DurationStatistics durationStatistics;
    private Collection<? extends Check> checksWithoutPreFilter;
    private PayloadTrie<Collection<SpecificationBasedCheck>> trie;
    private boolean initialized;

    public void initialize(Collection<Check> checks, SecretsSpecificationLoader specificationLoader, DurationStatistics durationStatistics) {
        if (this.initialized) {
            LOG.debug("ChecksContainer is already initialized, skipping re-initialization.");
            return;
        }
        LOG.debug("Initializing ChecksContainer with checks and trie construction.");
        List<Check> suitableChecks = TextAndSecretsAnalyzer.filterSuitableChecks(checks);
        Set specificationBasedChecks = suitableChecks.stream().filter(SpecificationBasedCheck.class::isInstance).map(SpecificationBasedCheck.class::cast).collect(Collectors.toSet());
        Map checksByPreFilters = ContentPreFilterUtils.getChecksByContentPreFilters(specificationBasedChecks, specificationLoader);
        Set checksWithPreFilter = checksByPreFilters.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        this.checksWithoutPreFilter = Stream.concat(suitableChecks.stream().filter(Predicate.not(SpecificationBasedCheck.class::isInstance)), specificationBasedChecks.stream().filter(Predicate.not(checksWithPreFilter::contains))).collect(Collectors.toSet());
        this.trie = durationStatistics.timed("trieBuild::general", () -> ContentPreFilterUtils.getPreprocessedTrie(checksByPreFilters));
        this.durationStatistics = durationStatistics;
        this.initialized = true;
        LOG.debug("ChecksContainer initialized successfully with {} checks without pre-filter and trie containing {} patterns.", (Object)this.checksWithoutPreFilter.size(), (Object)checksByPreFilters.size());
    }

    public void analyze(InputFileContext inputFileContext) {
        this.analyze(inputFileContext, (Check check) -> check.analyze(inputFileContext));
    }

    public void analyze(InputFileContext inputFileContext, String ruleId) {
        this.analyze(inputFileContext, (Check check) -> {
            if (check instanceof SpecificationBasedCheck) {
                SpecificationBasedCheck specificationBasedCheck = (SpecificationBasedCheck)check;
                specificationBasedCheck.analyze(inputFileContext, ruleId);
            } else {
                check.analyze(inputFileContext);
            }
        });
    }

    private void analyze(InputFileContext inputFileContext, Consumer<Check> executeCheck) {
        this.validateInitialized();
        SingleEmittingEmitHandler handler = new SingleEmittingEmitHandler();
        this.durationStatistics.timed("trieMatch::general", () -> this.trie.parseText((CharSequence)inputFileContext.content(), handler));
        Set emits = handler.getEmits();
        emits.stream().flatMap(Collection::stream).forEach(executeCheck);
        this.checksWithoutPreFilter.forEach(executeCheck);
        inputFileContext.flushIssues();
    }

    private void validateInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("ChecksContainer must be initialized before use. Call initialize() first.");
        }
    }

    boolean isInitialized() {
        return this.initialized;
    }

    private static class SingleEmittingEmitHandler<T>
    implements PayloadEmitHandler<T> {
        private final Set<T> emits = new HashSet<T>();

        private SingleEmittingEmitHandler() {
        }

        public Set<T> getEmits() {
            return this.emits;
        }

        @Override
        public boolean emit(PayloadEmit<T> emit) {
            return this.emits.add(emit.getPayload());
        }
    }
}

