/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.configuration.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Error;
import com.networknt.schema.InputFormat;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.SpecificationVersion;
import java.io.InputStream;
import java.util.List;
import org.sonar.plugins.secrets.configuration.validation.ResourceSchemaLoader;
import org.sonar.plugins.secrets.configuration.validation.SchemaValidationException;

public final class SchemaValidator {
    private static final String FILE_LOCATION = "/org/sonar/plugins/secrets/configuration/specifications/";
    private static final String VALIDATION_SCHEMA_FILE = "specification-json-schema.json";
    private static final Schema SPECIFICATION_VALIDATION_SCHEMA;

    private SchemaValidator() {
    }

    public static void validateSpecification(JsonNode specification, String fileName) {
        List<Error> validate = SchemaValidator.validate(specification);
        if (!validate.isEmpty()) {
            String errorMessage = "Specification file \"%s\" failed the schema validation".formatted(fileName);
            throw new SchemaValidationException(errorMessage);
        }
    }

    public static List<Error> validate(JsonNode specification) {
        return SPECIFICATION_VALIDATION_SCHEMA.validate(specification);
    }

    static {
        SchemaRegistry schemaRegistry = SchemaRegistry.withDefaultDialect(SpecificationVersion.DRAFT_2020_12, builder -> builder.resourceLoaders(loaders -> loaders.add(new ResourceSchemaLoader(FILE_LOCATION))));
        InputStream validationSchema = SchemaValidator.class.getResourceAsStream("/org/sonar/plugins/secrets/configuration/specifications/specification-json-schema.json");
        SPECIFICATION_VALIDATION_SCHEMA = schemaRegistry.getSchema(validationSchema, InputFormat.JSON);
    }
}

