/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.configuration.validation;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.IriResourceLoader;
import java.io.InputStream;
import java.net.URL;

final class ResourceSchemaLoader
extends IriResourceLoader {
    private final String localSchemaFolder;

    public ResourceSchemaLoader(String localSchemaFolder) {
        this.localSchemaFolder = localSchemaFolder;
    }

    @Override
    public InputStreamSource getResource(AbsoluteIri absoluteIri) {
        String resourcePath = this.localSchemaFolder + String.valueOf(absoluteIri);
        URL resourceUrl = ResourceSchemaLoader.class.getResource(resourcePath);
        if (resourceUrl != null) {
            return new ResourceInputStreamSource(resourcePath);
        }
        return super.getResource(absoluteIri);
    }

    record ResourceInputStreamSource(String resourcePath) implements InputStreamSource
    {
        @Override
        public InputStream getInputStream() {
            return ResourceSchemaLoader.class.getResourceAsStream(this.resourcePath);
        }
    }
}

