/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.configuration.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sonar.plugins.secrets.configuration.model.matching.BooleanCombination;
import org.sonar.plugins.secrets.configuration.model.matching.BooleanCombinationType;
import org.sonar.plugins.secrets.configuration.model.matching.Match;

public class BooleanCombinationDeserializer
extends JsonDeserializer<BooleanCombination> {
    @Override
    public BooleanCombination deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object treeNode = jsonParser.getCodec().readTree(jsonParser);
        Iterator<Map.Entry<String, JsonNode>> properties = ((ObjectNode)treeNode).properties().iterator();
        Map.Entry<String, JsonNode> node = properties.next();
        ArrayList<Match> modules = new ArrayList<Match>();
        if ("matchNot".equals(node.getKey())) {
            BooleanCombinationDeserializer.addMatch(jsonParser, node.getValue(), modules);
        } else {
            for (JsonNode matchNode : node.getValue()) {
                BooleanCombinationDeserializer.addMatch(jsonParser, matchNode, modules);
            }
        }
        BooleanCombination booleanCombination = new BooleanCombination();
        booleanCombination.setType(BooleanCombinationType.valueOfLabel(node.getKey()));
        booleanCombination.setMatches(modules);
        return booleanCombination;
    }

    private static void addMatch(JsonParser jsonParser, JsonNode matchNode, List<Match> modules) throws IOException {
        JsonParser matchNodeParser = matchNode.traverse();
        matchNodeParser.setCodec(jsonParser.getCodec());
        Match match = matchNodeParser.readValueAs(Match.class);
        modules.add(match);
    }
}

