/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.configuration;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.secrets.api.SecretsSpecificationLoader;
import org.sonar.plugins.secrets.api.SpecificationLoader;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="INSTANCE")
public class SecretsSpecificationContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsSpecificationContainer.class);
    private SpecificationLoader specificationLoader;

    public void initialize(Supplier<SpecificationLoader> constructSpecificationLoader, DurationStatistics durationStatistics) {
        if (this.specificationLoader == null) {
            LOG.debug("Initializing SecretsStateContainer with specification loader.");
            this.specificationLoader = durationStatistics.timed("deserializingSpecifications::general", constructSpecificationLoader);
        } else {
            LOG.debug("SecretsStateContainer is already initialized, skipping re-initialization.");
        }
    }

    public SecretsSpecificationLoader getSpecificationLoader() {
        if (this.specificationLoader == null) {
            throw new IllegalStateException("Secrets specification loader is not initialized.");
        }
        return (SecretsSpecificationLoader)this.specificationLoader;
    }
}

