/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api.task;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMatchingManager {
    private static final Logger LOG = LoggerFactory.getLogger(RegexMatchingManager.class);
    private static int timeoutMs = 10000;
    private static int uninterruptibleTimeoutMs = 60000;
    private static int threadCount = Runtime.getRuntime().availableProcessors();
    protected static ExecutorService executorService;

    private RegexMatchingManager() {
    }

    public static synchronized void initialize(int threads) {
        if (threads > 0) {
            threadCount = threads;
        }
        executorService = Executors.newFixedThreadPool(threadCount);
    }

    public static boolean runRegexMatchingWithTimeout(Runnable runnable, String pattern, String ruleId) {
        RegexMatchingManager.forceInitialization();
        Semaphore semaphore = new Semaphore(0);
        Future<?> future = RegexMatchingManager.submitWithSemaphore(runnable, semaphore);
        try {
            if (RegexMatchingManager.waitFutureCompletion(future, ruleId, timeoutMs)) {
                return true;
            }
            future.cancel(true);
            boolean terminationSuccessFull = semaphore.tryAcquire(timeoutMs, TimeUnit.MILLISECONDS);
            if (terminationSuccessFull) {
                return false;
            }
            String patternToDisplay = pattern.replace("\\", "\\\\");
            LOG.warn("Couldn't interrupt secret-matching task of rule with id \"{}\", waiting for it to finish. Related pattern is \"{}\"", (Object)ruleId, (Object)patternToDisplay);
            terminationSuccessFull = semaphore.tryAcquire(uninterruptibleTimeoutMs, TimeUnit.MILLISECONDS);
            if (!terminationSuccessFull) {
                RegexMatchingManager.reinitialize();
                throw new RuntimeException(String.format("Couldn't interrupt secret-matching task of rule with id \"%s\" after normal timeout(%dms) and interruption timeout(%dms). Related pattern is \"%s\"", ruleId, timeoutMs, uninterruptibleTimeoutMs, patternToDisplay));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private static Future<?> submitWithSemaphore(Runnable runnable, Semaphore semaphore) {
        return executorService.submit(() -> {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                semaphore.release();
            }
        });
    }

    private static boolean waitFutureCompletion(Future<?> future, String ruleId, int timeoutMs) throws ExecutionException, InterruptedException {
        try {
            future.get(timeoutMs, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (TimeoutException e) {
            LOG.debug("Timeout secret-matching task of rule with id \"{}\" after {}ms.", (Object)ruleId, (Object)timeoutMs);
            return false;
        }
    }

    public static synchronized void reinitialize() {
        ExecutorService oldExecutorService = executorService;
        RegexMatchingManager.initialize(threadCount);
        oldExecutorService.shutdown();
    }

    public static synchronized void forceInitialization() {
        if (executorService == null || executorService.isShutdown()) {
            RegexMatchingManager.initialize(threadCount);
        }
    }

    public static void shutdown() {
        executorService.shutdown();
    }

    public static int getTimeoutMs() {
        return timeoutMs;
    }

    public static void setTimeoutMs(int timeoutMs) {
        if (timeoutMs > 0) {
            RegexMatchingManager.timeoutMs = timeoutMs;
        }
    }

    public static int getUninterruptibleTimeoutMs() {
        return uninterruptibleTimeoutMs;
    }

    public static void setUninterruptibleTimeoutMs(int uninterruptibleTimeoutMs) {
        if (uninterruptibleTimeoutMs > 0) {
            RegexMatchingManager.uninterruptibleTimeoutMs = uninterruptibleTimeoutMs;
        }
    }
}

