/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.secrets.api.AbstractSpecificationBasedCheck;
import org.sonar.plugins.secrets.api.SecretMatcher;
import org.sonar.plugins.secrets.api.SecretsSpecificationLoader;
import org.sonar.plugins.secrets.api.SpecificationConfiguration;
import org.sonar.plugins.secrets.configuration.model.Rule;
import org.sonar.plugins.secrets.utils.ContentPreFilterUtils;

public abstract class SpecificationBasedCheck
extends AbstractSpecificationBasedCheck<SecretsSpecificationLoader, SecretMatcher> {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificationBasedCheck.class);

    protected SpecificationBasedCheck() {
    }

    @Override
    protected String repositoryKey() {
        return "secrets";
    }

    public List<Rule> retrieveRules(SecretsSpecificationLoader loader, String ruleKey) {
        return loader.getRulesForKey(ruleKey);
    }

    @Override
    protected void analyze(InputFileContext ctx, Predicate<String> ruleFilter) {
        for (SecretMatcher secretMatcher : this.matchers) {
            if (!ruleFilter.test(secretMatcher.getRuleId())) continue;
            this.durationStatistics.timed(secretMatcher.getRuleId() + "::total", () -> secretMatcher.findIn(ctx)).stream().map(match -> ctx.newTextRangeFromFileOffsets(match.fileStartOffset(), match.fileEndOffset())).forEach(textRange -> ctx.reportIssueOnTextRange(this.getRuleKey(), secretMatcher.getRuleSelectivity(), (TextRange)textRange, secretMatcher.getMessageFromRule()));
        }
    }

    @Override
    protected List<SecretMatcher> initializeMatchers(SecretsSpecificationLoader loader, String ruleId, SpecificationConfiguration specificationConfiguration) {
        List<Rule> rulesForKey = this.retrieveRules(loader, ruleId);
        if (rulesForKey.isEmpty()) {
            LOG.warn("Found no rule specification for rule with key: {}", (Object)ruleId);
        }
        boolean shouldExecuteContentPreFilters = rulesForKey.size() != 1 || !ContentPreFilterUtils.hasOptimizableContentPrefilters(rulesForKey);
        return rulesForKey.stream().map(rule -> SecretMatcher.build(rule, this.durationStatistics, specificationConfiguration, shouldExecuteContentPreFilters)).toList();
    }
}

