/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.secrets.SecretsSpecificationFilesDefinition;
import org.sonar.plugins.secrets.api.SpecificationLoader;
import org.sonar.plugins.secrets.configuration.deserialization.DeserializationException;
import org.sonar.plugins.secrets.configuration.deserialization.SpecificationDeserializer;
import org.sonar.plugins.secrets.configuration.model.Rule;
import org.sonar.plugins.secrets.configuration.model.Specification;
import org.sonar.plugins.secrets.configuration.validation.SchemaValidationException;

public class SecretsSpecificationLoader
implements SpecificationLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsSpecificationLoader.class);
    public static final String DEFAULT_SPECIFICATION_LOCATION = "org/sonar/plugins/secrets/configuration/";
    public static final ExceptionHandler DEFAULT_EXCEPTION_HANDLER = (e, specificationFileName) -> LOG.warn("{}: Could not load specification from file: {}", (Object)e.getClass().getSimpleName(), (Object)specificationFileName);
    private final Map<String, List<Rule>> rulesMappedToKey = new HashMap<String, List<Rule>>();
    private final Map<String, List<String>> keyMappedToFiles = new HashMap<String, List<String>>();
    private final ExceptionHandler exceptionHandler;

    public SecretsSpecificationLoader() {
        this(DEFAULT_SPECIFICATION_LOCATION, SecretsSpecificationFilesDefinition.existingSecretSpecifications(), DEFAULT_EXCEPTION_HANDLER);
    }

    public SecretsSpecificationLoader(String specificationLocation, Set<String> specifications) {
        this(specificationLocation, specifications, DEFAULT_EXCEPTION_HANDLER);
    }

    public SecretsSpecificationLoader(String specificationLocation, Set<String> specifications, ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        this.loadSpecifications(specificationLocation, specifications);
    }

    public SecretsSpecificationLoader(Map<String, Set<String>> specificationsByLocation, ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        for (Map.Entry<String, Set<String>> entry : specificationsByLocation.entrySet()) {
            this.loadSpecifications(entry.getKey(), entry.getValue());
        }
    }

    private void loadSpecifications(String specificationLocation, Set<String> specifications) {
        for (String specificationFileName : specifications) {
            Specification specification;
            try {
                specification = SecretsSpecificationLoader.loadSpecification(specificationLocation, specificationFileName);
            }
            catch (DeserializationException | SchemaValidationException e) {
                this.exceptionHandler.handle(e, specificationFileName);
                continue;
            }
            for (Rule rule : specification.getProvider().getRules()) {
                this.rulesMappedToKey.computeIfAbsent(rule.getRspecKey(), k -> new ArrayList()).add(rule);
                this.keyMappedToFiles.computeIfAbsent(rule.getRspecKey(), k -> new ArrayList()).add(specificationFileName);
            }
        }
    }

    private static Specification loadSpecification(String specificationLocation, String fileName) {
        InputStream specificationStream = SecretsSpecificationLoader.class.getClassLoader().getResourceAsStream(specificationLocation + fileName);
        return SpecificationDeserializer.deserialize(specificationStream, fileName);
    }

    public List<Rule> getRulesForKey(String key) {
        return this.rulesMappedToKey.getOrDefault(key, new ArrayList());
    }

    public List<String> getSpecificationFilesForKey(String key) {
        return this.keyMappedToFiles.getOrDefault(key, new ArrayList());
    }

    public Map<String, List<Rule>> getRulesMappedToKey() {
        return this.rulesMappedToKey;
    }

    public static interface ExceptionHandler {
        public void handle(Throwable var1, String var2);
    }
}

