/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.secrets.api.AuxiliaryPatternMatcher;
import org.sonar.plugins.secrets.api.AuxiliaryPatternMatcherFactory;
import org.sonar.plugins.secrets.api.Match;
import org.sonar.plugins.secrets.api.Matcher;
import org.sonar.plugins.secrets.api.PatternMatcher;
import org.sonar.plugins.secrets.api.PostFilterFactory;
import org.sonar.plugins.secrets.api.PreFilterFactory;
import org.sonar.plugins.secrets.api.SpecificationConfiguration;
import org.sonar.plugins.secrets.configuration.model.Rule;
import org.sonar.plugins.secrets.configuration.model.Selectivity;
import org.sonar.plugins.secrets.configuration.model.matching.filter.NamedPostModule;

public class SecretMatcher
implements Matcher {
    private final String ruleId;
    private final Selectivity ruleSelectivity;
    private final String ruleMessage;
    private final PatternMatcher patternMatcher;
    private final AuxiliaryPatternMatcher auxiliaryPatternMatcher;
    private final Predicate<InputFileContext> preFilter;
    private final Predicate<String> postFilter;
    private final Map<String, Predicate<String>> postFilterByGroup;
    private final DurationStatistics durationStatistics;

    SecretMatcher(String ruleId, String ruleMessage, Selectivity ruleSelectivity, PatternMatcher patternMatcher, AuxiliaryPatternMatcher auxiliaryPatternMatcher, Predicate<InputFileContext> preFilter, Predicate<String> postFilter, Map<String, Predicate<String>> postFilterByGroup, DurationStatistics durationStatistics) {
        this.ruleId = ruleId;
        this.ruleSelectivity = ruleSelectivity;
        this.ruleMessage = ruleMessage;
        this.patternMatcher = patternMatcher;
        this.auxiliaryPatternMatcher = auxiliaryPatternMatcher;
        this.preFilter = preFilter;
        this.postFilter = postFilter;
        this.postFilterByGroup = postFilterByGroup;
        this.durationStatistics = durationStatistics;
    }

    public static SecretMatcher build(Rule rule, DurationStatistics durationStatistics, SpecificationConfiguration specificationConfiguration, boolean shouldExecuteContentPreFilters) {
        PatternMatcher patternMatcher = PatternMatcher.build(rule.getDetection().getMatching());
        Predicate<InputFileContext> preFilter = PreFilterFactory.createPredicate(rule.getDetection().getPre(), rule.getSelectivity(), specificationConfiguration, shouldExecuteContentPreFilters);
        Predicate<String> postFilter = PostFilterFactory.createPredicate(rule.getDetection().getPost());
        Map<String, Predicate<String>> postFilterByGroup = Optional.ofNullable(rule.getDetection().getPost()).stream().flatMap(it -> it.getGroups().stream()).collect(Collectors.toMap(NamedPostModule::getName, PostFilterFactory::createPredicate));
        AuxiliaryPatternMatcher auxiliaryMatcher = AuxiliaryPatternMatcherFactory.build(rule.getDetection().getMatching());
        String ruleMessage = specificationConfiguration.messageFormatter().format(rule.getMetadata());
        return new SecretMatcher(rule.getId(), ruleMessage, rule.getSelectivity(), patternMatcher, auxiliaryMatcher, preFilter, postFilter, postFilterByGroup, durationStatistics);
    }

    @Override
    public List<Match> findIn(InputFileContext fileContext) {
        boolean isRejectedOnPreFilter = this.durationStatistics.timed(this.getRuleId() + "::preFilter", () -> !this.preFilter.test(fileContext));
        if (isRejectedOnPreFilter) {
            return Collections.emptyList();
        }
        String content = fileContext.content();
        List secretsFilteredOnContext = this.durationStatistics.timed(this.getRuleId() + "::matcher", () -> {
            List<Match> candidateSecrets = this.patternMatcher.findIn(content, this.getRuleId(), this.postFilterByGroup.keySet());
            return this.auxiliaryPatternMatcher.filter(candidateSecrets, fileContext, this.getRuleId());
        });
        return secretsFilteredOnContext.stream().filter(match -> this.durationStatistics.timed(this.getRuleId() + "::postFilter", () -> this.postFilter.test(match.text()) && match.groups().entrySet().stream().allMatch(entry -> this.postFilterByGroup.getOrDefault(entry.getKey(), s -> true).test(((Match)entry.getValue()).text())))).toList();
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getMessageFromRule() {
        return this.ruleMessage;
    }

    Predicate<String> getPostFilter() {
        return this.postFilter;
    }

    public Map<String, Predicate<String>> getPostFilterByGroup() {
        return this.postFilterByGroup;
    }

    AuxiliaryPatternMatcher getAuxiliaryPatternMatcher() {
        return this.auxiliaryPatternMatcher;
    }

    public Selectivity getRuleSelectivity() {
        return this.ruleSelectivity;
    }
}

