/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.secrets.api.AutomaticTestFileFilter;
import org.sonar.plugins.secrets.api.SpecificationConfiguration;
import org.sonar.plugins.secrets.configuration.model.Selectivity;
import org.sonar.plugins.secrets.configuration.model.matching.filter.FileFilter;
import org.sonar.plugins.secrets.configuration.model.matching.filter.PreModule;

public final class PreFilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PreFilterFactory.class);
    private static final Predicate<InputFileContext> NO_LANGUAGE_PREDICATE = ctx -> ctx.getInputFile().language() == null;
    private static final Predicate<InputFileContext> AUTOMATIC_NO_TEST_FILE_FILTER = AutomaticTestFileFilter.isNotAutomaticallyDetectedTestFile();
    public static final Predicate<InputFileContext> INCLUDE_ONLY_MAIN_FILES = ctx -> InputFile.Type.MAIN == ctx.getInputFile().type();

    private PreFilterFactory() {
    }

    public static Predicate<InputFileContext> createPredicate(@Nullable PreModule pre, Selectivity selectivity, SpecificationConfiguration specificationConfiguration, boolean shouldExecuteContentPreFilters) {
        Predicate<InputFileContext> predicate = PreFilterFactory.appendSelectivityPredicate(INCLUDE_ONLY_MAIN_FILES, selectivity);
        predicate = PreFilterFactory.appendAutomaticNoTestFileFilter(predicate, specificationConfiguration);
        if (pre == null) {
            return predicate;
        }
        FileFilter include = pre.getInclude();
        FileFilter reject = pre.getReject();
        if (reject != null) {
            predicate = predicate.and(ctx -> PreFilterFactory.notMatches(reject, ctx));
        }
        if (include != null) {
            predicate = predicate.and(ctx -> PreFilterFactory.matches(include, ctx, shouldExecuteContentPreFilters));
        }
        return predicate;
    }

    static Predicate<InputFileContext> appendSelectivityPredicate(Predicate<InputFileContext> predicate, Selectivity selectivity) {
        if (selectivity == Selectivity.ANALYZER_GENERIC) {
            return predicate.and(NO_LANGUAGE_PREDICATE);
        }
        return predicate;
    }

    public static Predicate<InputFileContext> appendAutomaticNoTestFileFilter(Predicate<InputFileContext> predicate, SpecificationConfiguration specificationConfiguration) {
        if (specificationConfiguration.automaticTestFileDetection()) {
            return predicate.and(AUTOMATIC_NO_TEST_FILE_FILTER);
        }
        return predicate;
    }

    private static boolean matches(FileFilter filter, InputFileContext ctx, boolean shouldExecuteContentPreFilters) {
        Predicate<InputFileContext> isPathMatch = c -> filter.getPaths().isEmpty() || PreFilterFactory.anyMatch(filter.getPaths(), PreFilterFactory::matchesPath, c);
        Predicate<InputFileContext> isExtMatch = c -> filter.getExt().isEmpty() || PreFilterFactory.anyMatch(filter.getExt(), PreFilterFactory::matchesExt, c);
        Predicate<InputFileContext> isContentMatch = c -> true;
        if (shouldExecuteContentPreFilters) {
            isContentMatch = c -> filter.getContent().isEmpty() || PreFilterFactory.anyMatch(filter.getContent(), PreFilterFactory::matchesContent, c);
        }
        return isPathMatch.and(isExtMatch).and(isContentMatch).test(ctx);
    }

    private static boolean notMatches(FileFilter filter, InputFileContext ctx) {
        Predicate<InputFileContext> isPathMatch = c -> PreFilterFactory.anyMatch(filter.getPaths(), PreFilterFactory::matchesPath, c);
        Predicate<InputFileContext> isExtMatch = c -> PreFilterFactory.anyMatch(filter.getExt(), PreFilterFactory::matchesExt, c);
        Predicate<InputFileContext> isContentMatch = c -> PreFilterFactory.anyMatch(filter.getContent(), PreFilterFactory::matchesContent, c);
        return Predicate.not(isPathMatch).and(Predicate.not(isExtMatch)).and(Predicate.not(isContentMatch)).test(ctx);
    }

    private static boolean anyMatch(List<String> filterElements, BiPredicate<String, InputFileContext> filterFunction, InputFileContext ctx) {
        return filterElements.stream().anyMatch(filterElement -> filterFunction.test((String)filterElement, ctx));
    }

    static boolean matchesPath(String path, InputFileContext ctx) {
        if (path.isBlank()) {
            LOG.warn("Parameter <paths> is blank in pre filter, will skip filtering");
            return false;
        }
        return ctx.getFileSystem().predicates().matchesPathPattern(path).apply(ctx.getInputFile());
    }

    static boolean matchesContent(String content, InputFileContext ctx) {
        if (content.isBlank()) {
            LOG.warn("Parameter <content> is blank in pre filter, will skip filtering");
            return false;
        }
        String contentLowerCase = content.toLowerCase(Locale.getDefault());
        return ctx.lines().stream().anyMatch(line -> line.toLowerCase(Locale.getDefault()).contains(contentLowerCase));
    }

    static boolean matchesExt(String ext, InputFileContext ctx) {
        if (ext.isBlank()) {
            LOG.warn("Parameter <ext> is blank in pre filter, will skip filtering");
            return false;
        }
        String extWithoutDot = ext.startsWith(".") ? ext.substring(ext.lastIndexOf(".") + 1) : ext;
        return ctx.getFileSystem().predicates().hasExtension(extWithoutDot).apply(ctx.getInputFile());
    }
}

