/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.secrets.api.EntropyChecker;
import org.sonar.plugins.secrets.api.Heuristics;
import org.sonar.plugins.secrets.configuration.model.matching.filter.AbstractPostModule;
import org.sonar.plugins.secrets.configuration.model.matching.filter.DecodedBase64Module;
import org.sonar.plugins.secrets.configuration.model.matching.filter.HeuristicsFilter;
import org.sonar.plugins.secrets.configuration.model.matching.filter.StatisticalFilter;

public final class PostFilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PostFilterFactory.class);

    private PostFilterFactory() {
    }

    public static Predicate<String> createPredicate(@Nullable AbstractPostModule post) {
        Predicate<String> postFilter = s -> true;
        if (post != null) {
            if (post.getDecodedBase64Module() != null) {
                postFilter = postFilter.and(input -> PostFilterFactory.matchBase64Decoded(post.getDecodedBase64Module(), input));
            }
            if (post.getStatisticalFilter() != null) {
                postFilter = postFilter.and(PostFilterFactory.filterForStatisticalFilter(post.getStatisticalFilter()));
            }
            if (!post.getPatternNot().isEmpty()) {
                postFilter = postFilter.and(PostFilterFactory.filterForPatternNot(post.getPatternNot()));
            }
            if (post.getHeuristicFilter() != null) {
                postFilter = postFilter.and(PostFilterFactory.filterForHeuristicsFilter(post.getHeuristicFilter()));
            }
        }
        return postFilter;
    }

    static Predicate<String> filterForPatternNot(List<String> patternNot) {
        String pipedPatterns = PostFilterFactory.pipePatternNot(patternNot);
        Pattern compiledPatternNot = Pattern.compile(pipedPatterns);
        return candidateSecret -> {
            Matcher matcher = compiledPatternNot.matcher((CharSequence)candidateSecret);
            return !matcher.find();
        };
    }

    static String pipePatternNot(List<String> patternNot) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < patternNot.size(); ++i) {
            sb.append("(?:");
            sb.append(patternNot.get(i));
            sb.append(")");
            if (i == patternNot.size() - 1) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    static Predicate<String> filterForStatisticalFilter(StatisticalFilter statisticalFilter) {
        return candidateSecret -> !EntropyChecker.hasLowEntropy(candidateSecret, statisticalFilter.getThreshold());
    }

    static Predicate<String> filterForHeuristicsFilter(HeuristicsFilter heuristicFilter) {
        return candidateSecret -> !Heuristics.matchesHeuristics(candidateSecret, heuristicFilter.getHeuristics());
    }

    /*
     * Unable to fully structure code
     */
    static boolean matchBase64Decoded(DecodedBase64Module decodedBase64Module, String candidateSecret) {
        switch (1.$SwitchMap$org$sonar$plugins$secrets$configuration$model$matching$filter$DecodedBase64Module$Alphabet[decodedBase64Module.alphabet().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: {
                v0 = candidateSecret.replace('.', '+').replace('_', '/').replace('-', '=');
                break;
            }
            case 2: {
                v0 = candidateSecret;
            }
        }
        stringToDecode = v0;
        try {
            decodedBytes = Base64.getDecoder().decode(stringToDecode);
        }
        catch (IllegalArgumentException iae) {
            PostFilterFactory.LOG.debug("Base64 decoding failed for input: {} (decoded with alphabet {})", (Object)stringToDecode, (Object)decodedBase64Module.alphabet());
            return false;
        }
        decoded = new String(decodedBytes, StandardCharsets.UTF_8);
        if (decodedBase64Module.matchEach().isEmpty()) ** GOTO lbl-1000
        if (decodedBase64Module.matchEach().stream().allMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.CharSequence ), (Ljava/lang/String;)Z)((String)decoded))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        matchEachResult = v1;
        matchNotResult = decodedBase64Module.matchNot().stream().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.CharSequence ), (Ljava/lang/String;)Z)((String)decoded));
        return matchEachResult != false && matchNotResult != false;
    }
}

