/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.secrets.api.Match;
import org.sonar.plugins.secrets.api.task.InterruptibleCharSequence;
import org.sonar.plugins.secrets.api.task.RegexMatchingManager;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPattern;
import org.sonar.plugins.secrets.configuration.model.matching.Matching;

public class PatternMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(PatternMatcher.class);
    private final Pattern pattern;

    PatternMatcher(@Nullable String stringPattern) {
        this.pattern = stringPattern != null ? Pattern.compile(stringPattern) : null;
    }

    public static PatternMatcher build(@Nullable Matching matching) {
        if (matching != null) {
            return new PatternMatcher(matching.getPattern());
        }
        return new PatternMatcher(null);
    }

    public static PatternMatcher build(String pattern) {
        return new PatternMatcher(pattern);
    }

    public static PatternMatcher build(AuxiliaryPattern auxiliaryPattern) {
        return new PatternMatcher(auxiliaryPattern.getPattern());
    }

    public List<Match> findIn(String content, String ruleId) {
        return this.findIn(content, ruleId, Collections.emptyList());
    }

    public List<Match> findIn(String content, String ruleId, Collection<String> expectedNamedGroups) {
        if (this.pattern == null) {
            return Collections.emptyList();
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        Matcher matcher = this.pattern.matcher(new InterruptibleCharSequence(content));
        boolean executedSuccessfully = RegexMatchingManager.runRegexMatchingWithTimeout(() -> {
            while (matcher.find()) {
                MatchResult matchResult = matcher.toMatchResult();
                if (matcher.groupCount() == 0) {
                    matches.add(new Match(matchResult.group(), matchResult.start(), matchResult.end(), Collections.emptyMap()));
                    continue;
                }
                Map<String, Match> namedMatches = expectedNamedGroups.stream().filter(it -> matcher.group((String)it) != null).collect(Collectors.toMap(Function.identity(), it -> new Match(matcher.group((String)it), matcher.start((String)it), matcher.end((String)it), Collections.emptyMap())));
                matches.add(new Match(matchResult.group(1), matchResult.start(1), matchResult.end(1), namedMatches));
            }
        }, this.pattern.pattern(), ruleId);
        if (!executedSuccessfully) {
            String patternToDisplay = this.pattern.pattern().replace("\\", "\\\\");
            LOG.warn("Running pattern in rule with id \"{}\" on content of length {} has timed out after {}ms. Related pattern is \"{}\".", ruleId, content.length(), RegexMatchingManager.getTimeoutMs(), patternToDisplay);
        }
        return matches;
    }
}

