/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heuristics {
    private static final int MINIMAL_NUMBER_OF_SEPARATORS_IN_VALID_PATH = 2;
    private static final double MINIMAL_RATIO_OF_SEPARATOR_SYMBOLS_IN_VALID_PATH = 0.15;
    private static final Pattern uriPattern = Pattern.compile("^(https?|ftps?|file|smtp|imap)://.*$");
    private static final Logger LOG = LoggerFactory.getLogger(Heuristics.class);

    private Heuristics() {
    }

    public static boolean matchesHeuristics(String candidateSecret, List<String> heuristics) {
        return heuristics.stream().anyMatch(heuristic -> {
            switch (heuristic) {
                case "path": {
                    return Heuristics.isPath(candidateSecret);
                }
                case "uri": {
                    return Heuristics.isUri(candidateSecret);
                }
            }
            LOG.warn("Heuristic with the name `{}` is not supported", heuristic);
            return false;
        });
    }

    public static boolean isPath(String input) {
        long fileSeparatorCount = input.chars().filter(c -> c == 47 || c == 92).count();
        return fileSeparatorCount >= 2L && (double)fileSeparatorCount * 1.0 / (double)input.length() >= 0.15;
    }

    public static boolean isUri(String input) {
        return uriPattern.matcher(input).matches();
    }
}

