/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import org.sonar.plugins.secrets.api.Match;

public final class DistanceValidation {
    private DistanceValidation() {
    }

    public static boolean isBefore(Match firstMatch, Match secondMatch) {
        return firstMatch.fileEndOffset() <= secondMatch.fileStartOffset();
    }

    public static boolean isAfter(Match firstMatch, Match secondMatch) {
        return firstMatch.fileStartOffset() >= secondMatch.fileEndOffset();
    }

    public static boolean inDistanceOf(Match firstMatch, Match secondMatch, int distance) {
        return DistanceValidation.inDistanceOf(firstMatch.fileStartOffset(), firstMatch.fileEndOffset(), secondMatch.fileStartOffset(), secondMatch.fileEndOffset(), distance);
    }

    public static boolean inDistanceOf(int firstMatchStart, int firstMatchEnd, int secondMatchStart, int secondMatchEnd, int distance) {
        boolean matchesOverlap;
        int firstEndToSecondStartDistance = firstMatchEnd - secondMatchStart;
        int firstStartToSecondEndDistance = firstMatchStart - secondMatchEnd;
        boolean bl = matchesOverlap = firstEndToSecondStartDistance >= 0 && firstStartToSecondEndDistance <= 0;
        if (matchesOverlap) {
            return true;
        }
        return Math.min(Math.abs(firstEndToSecondStartDistance), Math.abs(firstStartToSecondEndDistance)) <= distance;
    }
}

