/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.secrets.api.AuxiliaryMatcher;
import org.sonar.plugins.secrets.api.AuxiliaryPatternMatcher;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPattern;
import org.sonar.plugins.secrets.configuration.model.matching.BooleanCombination;
import org.sonar.plugins.secrets.configuration.model.matching.BooleanCombinationType;
import org.sonar.plugins.secrets.configuration.model.matching.Match;
import org.sonar.plugins.secrets.configuration.model.matching.Matching;

public class AuxiliaryPatternMatcherFactory {
    private AuxiliaryPatternMatcherFactory() {
    }

    public static AuxiliaryPatternMatcher build(@Nullable Matching matching) {
        if (matching == null || matching.getContext() == null) {
            return AuxiliaryPatternMatcher.NO_FILTERING_AUXILIARY_MATCHER;
        }
        return AuxiliaryPatternMatcherFactory.constructFrom(matching.getContext());
    }

    private static AuxiliaryPatternMatcher constructFrom(Match match) {
        if (match instanceof BooleanCombination) {
            BooleanCombination booleanCombination = (BooleanCombination)match;
            return AuxiliaryPatternMatcherFactory.constructFrom(booleanCombination);
        }
        return AuxiliaryPatternMatcherFactory.constructFrom((AuxiliaryPattern)match);
    }

    private static AuxiliaryPatternMatcher constructFrom(BooleanCombination booleanCombination) {
        List<Match> matches = booleanCombination.getMatches();
        AuxiliaryPatternMatcher resultingMatcher = AuxiliaryPatternMatcherFactory.constructFrom(matches.get(0));
        if (BooleanCombinationType.MATCH_NOT == booleanCombination.getType()) {
            return resultingMatcher.negate();
        }
        for (int i = 1; i < matches.size(); ++i) {
            AuxiliaryPatternMatcher matcher = AuxiliaryPatternMatcherFactory.constructFrom(matches.get(i));
            resultingMatcher = BooleanCombinationType.MATCH_EACH == booleanCombination.getType() ? resultingMatcher.and(matcher) : resultingMatcher.or(matcher);
        }
        return resultingMatcher;
    }

    private static AuxiliaryPatternMatcher constructFrom(AuxiliaryPattern auxiliaryPattern) {
        return AuxiliaryMatcher.build(auxiliaryPattern);
    }
}

